/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.GlobalVariableRepository;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.RouteVariableRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVariableRepositoryFactory
extends ServiceSupport
implements VariableRepositoryFactory,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultVariableRepositoryFactory.class);
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/variable-repository/";
    private final CamelContext camelContext;
    private VariableRepository global;
    private VariableRepository route;
    private FactoryFinder factoryFinder;

    public DefaultVariableRepositoryFactory(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public VariableRepository getVariableRepository(String id) {
        Class clazz;
        if (!this.isStarted()) {
            this.start();
        }
        if (this.global != null && "global".equals(id)) {
            return this.global;
        }
        if (this.route != null && "route".equals(id)) {
            return this.route;
        }
        VariableRepository repo = (VariableRepository)CamelContextHelper.lookup((CamelContext)this.camelContext, (String)id, VariableRepository.class);
        if (repo == null) {
            repo = (VariableRepository)CamelContextHelper.lookup((CamelContext)this.camelContext, (String)(id + "-variable-repository"), VariableRepository.class);
        }
        if (repo == null && (clazz = (Class)this.factoryFinder.findClass(id).orElse(null)) != null && VariableRepository.class.isAssignableFrom(clazz)) {
            repo = (VariableRepository)this.camelContext.getInjector().newInstance(clazz, true);
            this.camelContext.getRegistry().bind(id, (Object)repo);
            try {
                this.camelContext.addService((Object)repo);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return repo;
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.factoryFinder = this.camelContext.getCamelContextExtension().getBootstrapFactoryFinder(RESOURCE_PATH);
    }

    protected void doStart() throws Exception {
        super.doStart();
        VariableRepository repo = this.getVariableRepository("global");
        if (repo != null) {
            if (!(repo instanceof GlobalVariableRepository)) {
                LOG.info("Using VariableRepository: {} as global repository", (Object)repo.getId());
            }
            this.global = repo;
        } else {
            this.global = new GlobalVariableRepository();
            this.camelContext.getRegistry().bind("global-variable-repository", (Object)this.global);
        }
        repo = this.getVariableRepository("route");
        if (repo != null) {
            if (!(repo instanceof RouteVariableRepository)) {
                LOG.info("Using VariableRepository: {} as route repository", (Object)repo.getId());
            }
            this.route = repo;
        } else {
            this.route = new RouteVariableRepository();
            this.camelContext.getRegistry().bind("route-variable-repository", (Object)this.route);
        }
        if (!this.camelContext.hasService((Object)this.global)) {
            this.camelContext.addService((Object)this.global);
        }
        if (!this.camelContext.hasService((Object)this.route)) {
            this.camelContext.addService((Object)this.route);
            this.camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

                public void onRoutesRemove(Collection<Route> routes) {
                    for (Route r : routes) {
                        DefaultVariableRepositoryFactory.this.route.removeVariable(r.getRouteId() + ":*");
                    }
                }
            });
        }
    }
}

