/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.Consumer;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteIdAware;
import org.slf4j.MDC;

public class MDCThreadFactoryListener
implements ExecutorServiceManager.ThreadFactoryListener {
    public ThreadFactory onNewThreadFactory(Object source, ThreadFactory factory) {
        Consumer c;
        if (source instanceof Consumer && (c = (Consumer)source) instanceof RouteIdAware) {
            RouteIdAware ra = (RouteIdAware)c;
            String name = c.getEndpoint().getCamelContext().getName();
            String routeId = ra.getRouteId();
            if (routeId != null) {
                return this.newThreadFactory(name, routeId, factory);
            }
        }
        return factory;
    }

    private ThreadFactory newThreadFactory(String contextName, String routeId, ThreadFactory tf) {
        return task -> {
            Runnable wrapped = () -> {
                MDC.put((String)"camel.contextId", (String)contextName);
                MDC.put((String)"camel.routeId", (String)routeId);
                try {
                    task.run();
                }
                finally {
                    MDC.remove((String)"camel.contextId");
                    MDC.remove((String)"camel.routeId");
                }
            };
            return tf.newThread(wrapped);
        };
    }
}

