/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;

public class CamelExchangeException
extends CamelException {
    private static final long serialVersionUID = -8721487431101572630L;
    private final transient Exchange exchange;

    public CamelExchangeException(String message, Exchange exchange) {
        super(CamelExchangeException.createExceptionMessage(message, exchange, null));
        this.exchange = exchange;
    }

    public CamelExchangeException(String message, Exchange exchange, Throwable cause) {
        super(CamelExchangeException.createExceptionMessage(message, exchange, cause), cause);
        this.exchange = exchange;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public static String createExceptionMessage(String message, Exchange exchange, Throwable cause) {
        StringBuilder sb = new StringBuilder(1024);
        if (message != null) {
            sb.append(message);
        }
        if (exchange != null) {
            if (!sb.isEmpty()) {
                sb.append(". ");
            }
            sb.append(exchange);
        }
        if (cause != null) {
            if (!sb.isEmpty()) {
                sb.append(". ");
            }
            sb.append("Caused by: [").append(cause.getClass().getName()).append(" - ").append(cause.getMessage()).append(']');
        }
        return sb.toString().trim();
    }
}

