/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.util.ObjectHelper;

public class SetPropertyProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final Expression propertyName;
    private final Expression expression;

    public SetPropertyProcessor(Expression propertyName, Expression expression) {
        this.propertyName = propertyName;
        this.expression = expression;
        ObjectHelper.notNull((Object)propertyName, (String)"propertyName");
        ObjectHelper.notNull((Object)expression, (String)"expression");
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object newProperty = this.expression.evaluate(exchange, Object.class);
            if (exchange.getException() != null) {
                callback.done(true);
                return true;
            }
            String key = (String)this.propertyName.evaluate(exchange, String.class);
            exchange.setProperty(key, newProperty);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "setProperty[" + String.valueOf(this.propertyName) + ", " + String.valueOf(this.expression) + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getPropertyName() {
        return this.propertyName.toString();
    }

    public Expression getExpression() {
        return this.expression;
    }
}

