/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.text;

import java.util.Map;
import org.apache.shiro.config.Ini;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.realm.text.TextConfigurationRealm;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniRealm
extends TextConfigurationRealm {
    public static final String USERS_SECTION_NAME = "users";
    public static final String ROLES_SECTION_NAME = "roles";
    private static final Logger LOGGER = LoggerFactory.getLogger(IniRealm.class);
    private String resourcePath;
    private Ini ini;

    public IniRealm() {
    }

    public IniRealm(Ini ini) {
        this();
        this.processDefinitions(ini);
    }

    public IniRealm(String resourcePath) {
        this();
        Ini ini;
        this.ini = ini = Ini.fromResourcePath((String)resourcePath);
        this.resourcePath = resourcePath;
        this.processDefinitions(ini);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Ini getIni() {
        return this.ini;
    }

    public void setIni(Ini ini) {
        this.ini = ini;
    }

    @Override
    protected void onInit() {
        super.onInit();
        Ini ini = this.getIni();
        String resourcePath = this.getResourcePath();
        if (!CollectionUtils.isEmpty(this.users) || !CollectionUtils.isEmpty(this.roles)) {
            if (!CollectionUtils.isEmpty((Map)ini)) {
                LOGGER.warn("Users or Roles are already populated.  Configured Ini instance will be ignored.");
            }
            if (StringUtils.hasText((String)resourcePath)) {
                LOGGER.warn("Users or Roles are already populated.  resourcePath '{}' will be ignored.", (Object)resourcePath);
            }
            LOGGER.debug("Instance is already populated with users or roles.  No additional user/role population will be performed.");
            return;
        }
        if (CollectionUtils.isEmpty((Map)ini)) {
            LOGGER.debug("No INI instance configuration present.  Checking resourcePath...");
            if (StringUtils.hasText((String)resourcePath)) {
                LOGGER.debug("Resource path {} defined.  Creating INI instance.", (Object)resourcePath);
                ini = Ini.fromResourcePath((String)resourcePath);
                if (!CollectionUtils.isEmpty((Map)ini)) {
                    this.setIni(ini);
                }
            }
        }
        if (CollectionUtils.isEmpty((Map)ini)) {
            String msg = "Ini instance and/or resourcePath resulted in null or empty Ini configuration.  Cannot load account data.";
            throw new IllegalStateException(msg);
        }
        this.processDefinitions(ini);
    }

    private void processDefinitions(Ini ini) {
        Ini.Section usersSection;
        if (CollectionUtils.isEmpty((Map)ini)) {
            LOGGER.warn("{} defined, but the ini instance is null or empty.", (Object)this.getClass().getSimpleName());
            return;
        }
        Ini.Section rolesSection = ini.getSection(ROLES_SECTION_NAME);
        if (!CollectionUtils.isEmpty((Map)rolesSection)) {
            LOGGER.debug("Discovered the [{}] section.  Processing...", (Object)ROLES_SECTION_NAME);
            this.processRoleDefinitions((Map<String, String>)rolesSection);
        }
        if (!CollectionUtils.isEmpty((Map)(usersSection = ini.getSection(USERS_SECTION_NAME)))) {
            LOGGER.debug("Discovered the [{}] section.  Processing...", (Object)USERS_SECTION_NAME);
            this.processUserDefinitions((Map<String, String>)usersSection);
        } else {
            LOGGER.info("{} defined, but there is no [{}] section defined.  This realm will not be populated with any users and it is assumed that they will be populated programmatically.  Users must be defined for this Realm instance to be useful.", (Object)this.getClass().getSimpleName(), (Object)USERS_SECTION_NAME);
        }
    }
}

