/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.CombinedServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.CombinedServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ServiceCallExpressionConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ZooKeeperServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="serviceCall")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Deprecated(since="3.19.0")
public class ServiceCallDefinition
extends NoOutputDefinition<ServiceCallDefinition> {
    @XmlAttribute
    @Metadata(required=true)
    private String name;
    @XmlAttribute
    private String uri;
    @XmlAttribute
    @Metadata(defaultValue="http")
    private String component;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.ExchangePattern", enums="InOnly,InOut")
    private String pattern;
    @XmlAttribute
    private String configurationRef;
    @XmlAttribute
    private String serviceDiscoveryRef;
    @XmlTransient
    private ServiceDiscovery serviceDiscovery;
    @XmlAttribute
    private String serviceFilterRef;
    @XmlTransient
    private ServiceFilter serviceFilter;
    @XmlAttribute
    private String serviceChooserRef;
    @XmlTransient
    private ServiceChooser serviceChooser;
    @XmlAttribute
    private String loadBalancerRef;
    @XmlTransient
    private ServiceLoadBalancer loadBalancer;
    @XmlAttribute
    private String expressionRef;
    @XmlTransient
    private Expression expression;
    @XmlElements(value={@XmlElement(name="cachingServiceDiscovery", type=CachingServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="combinedServiceDiscovery", type=CombinedServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="consulServiceDiscovery", type=ConsulServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="dnsServiceDiscovery", type=DnsServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="kubernetesServiceDiscovery", type=KubernetesServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="staticServiceDiscovery", type=StaticServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="zookeeperServiceDiscovery", type=ZooKeeperServiceCallServiceDiscoveryConfiguration.class)})
    private ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    @XmlElements(value={@XmlElement(name="blacklistServiceFilter", type=BlacklistServiceCallServiceFilterConfiguration.class), @XmlElement(name="combinedServiceFilter", type=CombinedServiceCallServiceFilterConfiguration.class), @XmlElement(name="customServiceFilter", type=CustomServiceCallServiceFilterConfiguration.class), @XmlElement(name="healthyServiceFilter", type=HealthyServiceCallServiceFilterConfiguration.class), @XmlElement(name="passThroughServiceFilter", type=PassThroughServiceCallServiceFilterConfiguration.class)})
    private ServiceCallServiceFilterConfiguration serviceFilterConfiguration;
    @XmlElements(value={@XmlElement(name="defaultLoadBalancer", type=DefaultServiceCallServiceLoadBalancerConfiguration.class)})
    private ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration;
    @XmlElement(name="expression")
    private ServiceCallExpressionConfiguration expressionConfiguration;

    public ServiceCallDefinition() {
    }

    public ServiceCallDefinition(String name) {
        this.name = name;
    }

    @Override
    public ProcessorDefinition<?> copyDefinition() {
        return this;
    }

    public String toString() {
        return "ServiceCall[" + this.name + "]";
    }

    public String getShortName() {
        return "serviceCall";
    }

    @Override
    public String getLabel() {
        return "serviceCall";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getConfigurationRef() {
        return this.configurationRef;
    }

    public void setConfigurationRef(String configurationRef) {
        this.configurationRef = configurationRef;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getServiceDiscoveryRef() {
        return this.serviceDiscoveryRef;
    }

    public void setServiceDiscoveryRef(String serviceDiscoveryRef) {
        this.serviceDiscoveryRef = serviceDiscoveryRef;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public String getServiceFilterRef() {
        return this.serviceFilterRef;
    }

    public void setServiceFilterRef(String serviceFilterRef) {
        this.serviceFilterRef = serviceFilterRef;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    public void setServiceFilter(ServiceFilter serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    public String getServiceChooserRef() {
        return this.serviceChooserRef;
    }

    public void setServiceChooserRef(String serviceChooserRef) {
        this.serviceChooserRef = serviceChooserRef;
    }

    public ServiceChooser getServiceChooser() {
        return this.serviceChooser;
    }

    public void setServiceChooser(ServiceChooser serviceChooser) {
        this.serviceChooser = serviceChooser;
    }

    public String getLoadBalancerRef() {
        return this.loadBalancerRef;
    }

    public void setLoadBalancerRef(String loadBalancerRef) {
        this.loadBalancerRef = loadBalancerRef;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(ServiceLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public String getExpressionRef() {
        return this.expressionRef;
    }

    public void setExpressionRef(String expressionRef) {
        if (this.expressionConfiguration == null) {
            this.expressionConfiguration = new ServiceCallExpressionConfiguration();
        }
        this.expressionConfiguration.expressionType(new RefExpression(expressionRef));
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ServiceCallServiceDiscoveryConfiguration getServiceDiscoveryConfiguration() {
        return this.serviceDiscoveryConfiguration;
    }

    public void setServiceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.serviceDiscoveryConfiguration = serviceDiscoveryConfiguration;
    }

    public ServiceCallServiceFilterConfiguration getServiceFilterConfiguration() {
        return this.serviceFilterConfiguration;
    }

    public void setServiceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.serviceFilterConfiguration = serviceFilterConfiguration;
    }

    public ServiceCallServiceLoadBalancerConfiguration getLoadBalancerConfiguration() {
        return this.loadBalancerConfiguration;
    }

    public void setLoadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration) {
        this.loadBalancerConfiguration = loadBalancerConfiguration;
    }

    public ServiceCallExpressionConfiguration getExpressionConfiguration() {
        return this.expressionConfiguration;
    }

    public void setExpressionConfiguration(ServiceCallExpressionConfiguration expressionConfiguration) {
        this.expressionConfiguration = expressionConfiguration;
    }

    public ServiceCallDefinition pattern(ExchangePattern pattern) {
        return this.pattern(pattern.name());
    }

    public ServiceCallDefinition pattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ServiceCallDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public ServiceCallDefinition uri(String uri) {
        this.setUri(uri);
        return this;
    }

    public ServiceCallDefinition component(String component) {
        this.setComponent(component);
        return this;
    }

    public ServiceCallDefinition serviceCallConfiguration(String ref) {
        this.configurationRef = ref;
        return this;
    }

    public ServiceCallDefinition serviceDiscovery(String serviceDiscoveryRef) {
        this.setServiceDiscoveryRef(serviceDiscoveryRef);
        return this;
    }

    public ServiceCallDefinition serviceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.setServiceDiscovery(serviceDiscovery);
        return this;
    }

    public ServiceCallDefinition serviceFilter(String serviceFilterRef) {
        this.setServiceDiscoveryRef(this.serviceDiscoveryRef);
        return this;
    }

    public ServiceCallDefinition serviceFilter(ServiceFilter serviceFilter) {
        this.setServiceFilter(serviceFilter);
        return this;
    }

    public ServiceCallDefinition serviceChooser(String serviceChooserRef) {
        this.setServiceChooserRef(serviceChooserRef);
        return this;
    }

    public ServiceCallDefinition serviceChooser(ServiceChooser serviceChooser) {
        this.setServiceChooser(serviceChooser);
        return this;
    }

    public ServiceCallDefinition loadBalancer(String loadBalancerRef) {
        this.setLoadBalancerRef(loadBalancerRef);
        return this;
    }

    public ServiceCallDefinition loadBalancer(ServiceLoadBalancer loadBalancer) {
        this.setLoadBalancer(loadBalancer);
        return this;
    }

    public ServiceCallDefinition expression(String expressionRef) {
        this.setExpressionRef(expressionRef);
        return this;
    }

    public ServiceCallDefinition expression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public ExpressionClause<ServiceCallDefinition> expression() {
        ExpressionClause<ServiceCallDefinition> clause = new ExpressionClause<ServiceCallDefinition>(this);
        this.setExpression(clause);
        return clause;
    }

    public ServiceCallDefinition serviceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.setServiceDiscoveryConfiguration(serviceDiscoveryConfiguration);
        return this;
    }

    public ServiceCallDefinition serviceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.setServiceFilterConfiguration(serviceFilterConfiguration);
        return this;
    }

    public ServiceCallDefinition loadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration) {
        this.setLoadBalancerConfiguration(loadBalancerConfiguration);
        return this;
    }

    public ServiceCallDefinition expressionConfiguration(ServiceCallExpressionConfiguration expressionConfiguration) {
        this.setExpressionConfiguration(expressionConfiguration);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration cachingServiceDiscovery() {
        CachingServiceCallServiceDiscoveryConfiguration conf = new CachingServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ConsulServiceCallServiceDiscoveryConfiguration consulServiceDiscovery() {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition consulServiceDiscovery(String url) {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration(this);
        conf.setUrl(url);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public DnsServiceCallServiceDiscoveryConfiguration dnsServiceDiscovery() {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition dnsServiceDiscovery(String domain) {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration(this);
        conf.setDomain(domain);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition dnsServiceDiscovery(String domain, String protocol) {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration(this);
        conf.setDomain(domain);
        conf.setProto(protocol);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesClientServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        conf.setLookup("client");
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition kubernetesEnvServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        conf.setLookup("environment");
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition kubernetesDnsServiceDiscovery(String namespace, String domain) {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration(this);
        conf.setLookup("dns");
        conf.setNamespace(namespace);
        conf.setDnsDomain(domain);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public CombinedServiceCallServiceDiscoveryConfiguration combinedServiceDiscovery() {
        CombinedServiceCallServiceDiscoveryConfiguration conf = new CombinedServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public StaticServiceCallServiceDiscoveryConfiguration staticServiceDiscovery() {
        StaticServiceCallServiceDiscoveryConfiguration conf = new StaticServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ZooKeeperServiceCallServiceDiscoveryConfiguration zookeeperServiceDiscovery() {
        ZooKeeperServiceCallServiceDiscoveryConfiguration conf = new ZooKeeperServiceCallServiceDiscoveryConfiguration(this);
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition zookeeperServiceDiscovery(String nodes, String basePath) {
        ZooKeeperServiceCallServiceDiscoveryConfiguration conf = new ZooKeeperServiceCallServiceDiscoveryConfiguration(this);
        conf.setNodes(nodes);
        conf.setBasePath(basePath);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition healthyFilter() {
        HealthyServiceCallServiceFilterConfiguration conf = new HealthyServiceCallServiceFilterConfiguration(this);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition passThroughFilter() {
        PassThroughServiceCallServiceFilterConfiguration conf = new PassThroughServiceCallServiceFilterConfiguration(this);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public CombinedServiceCallServiceFilterConfiguration combinedFilter() {
        CombinedServiceCallServiceFilterConfiguration conf = new CombinedServiceCallServiceFilterConfiguration(this);
        this.setServiceFilterConfiguration(conf);
        return conf;
    }

    public BlacklistServiceCallServiceFilterConfiguration blacklistFilter() {
        BlacklistServiceCallServiceFilterConfiguration conf = new BlacklistServiceCallServiceFilterConfiguration();
        this.setServiceFilterConfiguration(conf);
        return conf;
    }

    public ServiceCallDefinition customFilter(String serviceFilter) {
        CustomServiceCallServiceFilterConfiguration conf = new CustomServiceCallServiceFilterConfiguration();
        conf.setServiceFilterRef(serviceFilter);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition customFilter(ServiceFilter serviceFilter) {
        CustomServiceCallServiceFilterConfiguration conf = new CustomServiceCallServiceFilterConfiguration();
        conf.setServiceFilter(serviceFilter);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallDefinition defaultLoadBalancer() {
        DefaultServiceCallServiceLoadBalancerConfiguration conf = new DefaultServiceCallServiceLoadBalancerConfiguration();
        this.setLoadBalancerConfiguration(conf);
        return this;
    }
}

