/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import org.apache.zookeeper.server.watch.WatcherMode;

public final class WatchStats {
    private static final WatchStats[] WATCH_STATS = new WatchStats[]{new WatchStats(0), new WatchStats(1), new WatchStats(2), new WatchStats(3), new WatchStats(4), new WatchStats(5), new WatchStats(6), new WatchStats(7)};
    public static final WatchStats NONE = WATCH_STATS[0];
    private final int flags;

    private WatchStats(int flags) {
        this.flags = flags;
    }

    private static int modeToFlag(WatcherMode mode) {
        return 1 << mode.ordinal();
    }

    public WatchStats addMode(WatcherMode mode) {
        int flags = this.flags | WatchStats.modeToFlag(mode);
        return WATCH_STATS[flags];
    }

    public WatchStats removeMode(WatcherMode mode) {
        int mask = ~WatchStats.modeToFlag(mode);
        int flags = this.flags & mask;
        if (flags == 0) {
            return NONE;
        }
        return WATCH_STATS[flags];
    }

    public boolean hasMode(WatcherMode mode) {
        int flags = WatchStats.modeToFlag(mode);
        return (this.flags & flags) != 0;
    }
}

