/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509;

import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidator;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class CommonX509TrustManager
implements X509TrustManager {
    private X509CertChainValidator validator;

    public CommonX509TrustManager(X509CertChainValidator validator) {
        this.validator = validator;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ValidationResult result = this.validator.validate(chain);
        if (result.isValid()) {
            return;
        }
        throw new CertificateException(result.toString());
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ValidationResult result = this.validator.validate(chain);
        if (result.isValid()) {
            return;
        }
        throw new CertificateException(result.toString());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.validator.getTrustedIssuers();
    }
}

