/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.component.xml.builder;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.utils.component.xml.builder.ComponentConfigBuilder;
import org.wso2.carbon.utils.component.xml.config.ComponentConfig;
import org.wso2.carbon.utils.component.xml.config.HTTPGetRequestProcessorConfig;

public class HTTPGetRequestProcessorConfigBuilder
extends ComponentConfigBuilder {
    @Override
    public ComponentConfig[] build(OMElement configElement) throws CarbonException {
        ArrayList<HTTPGetRequestProcessorConfig> getRequestProcessorConfigList = new ArrayList<HTTPGetRequestProcessorConfig>();
        Iterator iterator = configElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "processor"));
        while (iterator.hasNext()) {
            OMElement processorElement = (OMElement)iterator.next();
            OMElement itemElement = processorElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "item"));
            String item = null;
            if (itemElement != null) {
                item = itemElement.getText().trim();
            }
            if (item == null) {
                throw new CarbonException("Mandatory element processor/item entry does not exist or is empty in the component.xml");
            }
            OMElement classElement = processorElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "class"));
            String className = null;
            if (classElement != null) {
                className = classElement.getText().trim();
            }
            if (className == null) {
                throw new CarbonException("Mandatory element processor/class entry does not exist or is empty in the component.xml");
            }
            HTTPGetRequestProcessorConfig getRequestProcessorConfig = new HTTPGetRequestProcessorConfig();
            getRequestProcessorConfig.setItem(item);
            getRequestProcessorConfig.setClassName(className);
            getRequestProcessorConfigList.add(getRequestProcessorConfig);
        }
        if (getRequestProcessorConfigList.size() == 0) {
            return null;
        }
        HTTPGetRequestProcessorConfig[] getRequestProcessorConfigs = new HTTPGetRequestProcessorConfig[getRequestProcessorConfigList.size()];
        return getRequestProcessorConfigList.toArray(getRequestProcessorConfigs);
    }

    @Override
    public String getLocalNameOfComponentConfigElement() {
        return "httpGetRequestProcessors";
    }
}

