/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.BatchQueue;
import org.apache.airavata.registry.core.app.catalog.model.BatchQueue_PK;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchQueueResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(BatchQueueResource.class);
    private String computeResourceId;
    private ComputeResourceResource computeHostResource;
    private int maxRuntime;
    private int maxJobInQueue;
    private String queueDescription;
    private String queueName;
    private int maxProcessors;
    private int maxNodes;
    private int maxMemory;
    private int cpuPerNode;
    private int defaultNodeCount;
    private int defaultCPUCount;
    private int defaultWalltime;
    private String queueSpecificMacros;
    private boolean isDefaultQueue;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("BatchQueue", new Object[0][]);
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            generator.setParameter("queueName", ids.get("queueName"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("BatchQueue", new Object[0][]);
            generator.setParameter("computeResourceId", ids.get("computeResourceId"));
            generator.setParameter("queueName", ids.get("queueName"));
            Query q = generator.selectQuery(em);
            BatchQueue batchQueue = (BatchQueue)q.getSingleResult();
            BatchQueueResource batchQueueResource = (BatchQueueResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.BATCH_QUEUE, batchQueue);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            BatchQueueResource batchQueueResource2 = batchQueueResource;
            return batchQueueResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> batchQueueResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("BatchQueue", new Object[0][]);
            if (fieldName.equals("computeResourceId") || fieldName.equals("maxRuntime") || fieldName.equals("maxJobInQueue") || fieldName.equals("queueDescription") || fieldName.equals("queueName") || fieldName.equals("maxProcessors") || fieldName.equals("maxNodes")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    BatchQueue batchQueue = (BatchQueue)result;
                    BatchQueueResource batchQueueResource = (BatchQueueResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.BATCH_QUEUE, batchQueue);
                    batchQueueResources.add(batchQueueResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Batch Queue Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Batch Queue Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return batchQueueResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> batchQueueResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("BatchQueue", new Object[0][]);
            if (fieldName.equals("computeResourceId") || fieldName.equals("maxRuntime") || fieldName.equals("maxJobInQueue") || fieldName.equals("queueDescription") || fieldName.equals("queueName") || fieldName.equals("maxProcessors") || fieldName.equals("maxNodes")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    BatchQueue batchQueue = (BatchQueue)result;
                    BatchQueueResource batchQueueResource = (BatchQueueResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.BATCH_QUEUE, batchQueue);
                    batchQueueResourceIDs.add(batchQueueResource.getComputeResourceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Batch Queue Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Batch Queue Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return batchQueueResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            BatchQueue existingBatchQueue = (BatchQueue)em.find(BatchQueue.class, (Object)new BatchQueue_PK(this.computeResourceId, this.queueName));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            BatchQueue batchQueue = existingBatchQueue == null ? new BatchQueue() : existingBatchQueue;
            batchQueue.setComputeResourceId(this.getComputeResourceId());
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.getComputeResourceId());
            batchQueue.setComputeResource(computeResource);
            batchQueue.setMaxRuntime(this.getMaxRuntime());
            batchQueue.setMaxJobInQueue(this.getMaxJobInQueue());
            batchQueue.setQueueDescription(this.getQueueDescription());
            batchQueue.setQueueName(this.getQueueName());
            batchQueue.setMaxProcessors(this.getMaxProcessors());
            batchQueue.setMaxNodes(this.getMaxNodes());
            batchQueue.setMaxMemory(this.getMaxMemory());
            batchQueue.setCpuPerNode(this.getCpuPerNode());
            batchQueue.setDefaultCPUCount(this.getDefaultCPUCount());
            batchQueue.setDefaultNodeCount(this.getDefaultNodeCount());
            batchQueue.setDefaultWalltime(this.getDefaultWalltime());
            batchQueue.setQueueSpecificMacros(this.getQueueSpecificMacros());
            batchQueue.setIsDefaultQueue(this.isDefaultQueue());
            if (existingBatchQueue == null) {
                em.persist((Object)batchQueue);
            } else {
                em.merge((Object)batchQueue);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            BatchQueue batchQueue = (BatchQueue)em.find(BatchQueue.class, (Object)new BatchQueue_PK((String)ids.get("computeResourceId"), (String)ids.get("queueName")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = batchQueue != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public ComputeResourceResource getComputeHostResource() {
        return this.computeHostResource;
    }

    public int getMaxRuntime() {
        return this.maxRuntime;
    }

    public int getMaxJobInQueue() {
        return this.maxJobInQueue;
    }

    public String getQueueDescription() {
        return this.queueDescription;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    public void setComputeHostResource(ComputeResourceResource computeHostResource) {
        this.computeHostResource = computeHostResource;
    }

    public void setMaxRuntime(int maxRuntime) {
        this.maxRuntime = maxRuntime;
    }

    public void setMaxJobInQueue(int maxJobInQueue) {
        this.maxJobInQueue = maxJobInQueue;
    }

    public void setQueueDescription(String queueDescription) {
        this.queueDescription = queueDescription;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public int getCpuPerNode() {
        return this.cpuPerNode;
    }

    public void setCpuPerNode(int cpuPerNode) {
        this.cpuPerNode = cpuPerNode;
    }

    public int getDefaultNodeCount() {
        return this.defaultNodeCount;
    }

    public void setDefaultNodeCount(int defaultNodeCount) {
        this.defaultNodeCount = defaultNodeCount;
    }

    public int getDefaultCPUCount() {
        return this.defaultCPUCount;
    }

    public void setDefaultCPUCount(int defaultCPUCount) {
        this.defaultCPUCount = defaultCPUCount;
    }

    public boolean isDefaultQueue() {
        return this.isDefaultQueue;
    }

    public void setIsDefaultQueue(boolean isDefaultQueue) {
        this.isDefaultQueue = isDefaultQueue;
    }

    public int getDefaultWalltime() {
        return this.defaultWalltime;
    }

    public void setDefaultWalltime(int defaultWalltime) {
        this.defaultWalltime = defaultWalltime;
    }

    public String getQueueSpecificMacros() {
        return this.queueSpecificMacros;
    }

    public void setQueueSpecificMacros(String queueSpecificMacros) {
        this.queueSpecificMacros = queueSpecificMacros;
    }
}

