/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationDeployment;
import org.apache.airavata.registry.core.app.catalog.model.ModuleLoadCmd;
import org.apache.airavata.registry.core.app.catalog.model.ModuleLoadCmd_PK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppDeploymentResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleLoadCmdResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ModuleLoadCmdResource.class);
    private String cmd;
    private String appDeploymentId;
    private Integer order;
    private AppDeploymentResource appDeploymentResource;

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ModuleLoadCmd", new Object[0][]);
            generator.setParameter("appDeploymentId", ids.get("appDeploymentId"));
            if (ids.get("cmd") != null) {
                generator.setParameter("cmd", ids.get("cmd"));
            }
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ModuleLoadCmd", new Object[0][]);
            generator.setParameter("cmd", ids.get("cmd"));
            generator.setParameter("appDeploymentId", ids.get("appDeploymentId"));
            Query q = generator.selectQuery(em);
            ModuleLoadCmd moduleLoadCmd = (ModuleLoadCmd)q.getSingleResult();
            ModuleLoadCmdResource moduleLoadCmdResource = (ModuleLoadCmdResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.MODULE_LOAD_CMD, moduleLoadCmd);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ModuleLoadCmdResource moduleLoadCmdResource2 = moduleLoadCmdResource;
            return moduleLoadCmdResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> moduleLoadCmdResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ModuleLoadCmd", new Object[0][]);
            if (fieldName.equals("cmd") || fieldName.equals("appDeploymentId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ModuleLoadCmd moduleLoadCmd = (ModuleLoadCmd)result;
                    ModuleLoadCmdResource moduleLoadCmdResource = (ModuleLoadCmdResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.MODULE_LOAD_CMD, moduleLoadCmd);
                    moduleLoadCmdResources.add(moduleLoadCmdResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Module Load Cmd Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Module Load Cmd Resource.");
            }
            Collections.sort(moduleLoadCmdResources, (o1, o2) -> ((ModuleLoadCmdResource)o1).getOrder() - ((ModuleLoadCmdResource)o2).getOrder());
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return moduleLoadCmdResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> moduleLoadCmdResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ModuleLoadCmd", new Object[0][]);
            if (fieldName.equals("cmd") || fieldName.equals("appDeploymentId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ModuleLoadCmd moduleLoadCmd = (ModuleLoadCmd)result;
                    ModuleLoadCmdResource moduleLoadCmdResource = (ModuleLoadCmdResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.MODULE_LOAD_CMD, moduleLoadCmd);
                    moduleLoadCmdResourceIDs.add(moduleLoadCmdResource.getAppDeploymentId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Module Load Cmd Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Module Load Cmd Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return moduleLoadCmdResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ModuleLoadCmd existingModuleLoadCmd = (ModuleLoadCmd)em.find(ModuleLoadCmd.class, (Object)new ModuleLoadCmd_PK(this.cmd, this.appDeploymentId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ModuleLoadCmd moduleLoadCmd = existingModuleLoadCmd == null ? new ModuleLoadCmd() : existingModuleLoadCmd;
            moduleLoadCmd.setCmd(this.getCmd());
            moduleLoadCmd.setAppDeploymentId(this.getAppDeploymentId());
            moduleLoadCmd.setOrder(this.order);
            ApplicationDeployment applicationDeployment = (ApplicationDeployment)em.find(ApplicationDeployment.class, (Object)this.getAppDeploymentId());
            moduleLoadCmd.setApplicationDeployment(applicationDeployment);
            if (existingModuleLoadCmd == null) {
                em.persist((Object)moduleLoadCmd);
            } else {
                em.merge((Object)moduleLoadCmd);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ModuleLoadCmd moduleLoadCmd = (ModuleLoadCmd)em.find(ModuleLoadCmd.class, (Object)new ModuleLoadCmd_PK((String)ids.get("cmd"), (String)ids.get("appDeploymentId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = moduleLoadCmd != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getAppDeploymentId() {
        return this.appDeploymentId;
    }

    public AppDeploymentResource getAppDeploymentResource() {
        return this.appDeploymentResource;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setAppDeploymentId(String appDeploymentId) {
        this.appDeploymentId = appDeploymentId;
    }

    public void setAppDeploymentResource(AppDeploymentResource appDeploymentResource) {
        this.appDeploymentResource = appDeploymentResource;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }
}

