/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentSummaryModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.GatewayApprovalStatus;
import org.apache.airavata.model.workspace.Notification;
import org.apache.airavata.model.workspace.NotificationPriority;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentInputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentOutputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ExperimentSummaryResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.GatewayResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.JobStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.NotificationResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessInputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessOutputResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessResourceScheduleResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProcessStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectUserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskErrorResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.TaskStatusResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserConfigurationDataResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftDataModelConversion {
    private static final Logger logger = LoggerFactory.getLogger(ThriftDataModelConversion.class);

    public static Project getProject(ProjectResource pr) throws RegistryException {
        if (pr != null) {
            Project project = new Project();
            project.setProjectID(pr.getId());
            project.setName(pr.getName());
            if (pr.getCreationTime() != null) {
                project.setCreationTime(pr.getCreationTime().getTime());
            }
            project.setDescription(pr.getDescription());
            project.setOwner(pr.getWorker().getUser());
            project.setGatewayId(pr.getGatewayId());
            List<ProjectUserResource> projectUserList = pr.getProjectUserList();
            ArrayList<String> sharedUsers = new ArrayList<String>();
            if (projectUserList != null && !projectUserList.isEmpty()) {
                for (ProjectUserResource resource : projectUserList) {
                    sharedUsers.add(resource.getUserName());
                }
            }
            project.setSharedUsers(sharedUsers);
            return project;
        }
        return null;
    }

    public static Gateway getGateway(GatewayResource resource) {
        Gateway gateway = new Gateway();
        gateway.setGatewayId(resource.getGatewayId());
        gateway.setGatewayApprovalStatus(GatewayApprovalStatus.valueOf((String)resource.getGatewayApprovalStatus()));
        gateway.setGatewayName(resource.getGatewayName());
        gateway.setDomain(resource.getDomain());
        gateway.setEmailAddress(resource.getEmailAddress());
        gateway.setGatewayAcronym(resource.getGatewayAcronym());
        gateway.setGatewayURL(resource.getGatewayUrl());
        gateway.setGatewayPublicAbstract(resource.getGatewayPublicAbstract());
        gateway.setReviewProposalDescription(resource.getReviewProposalDescription());
        gateway.setDeclinedReason(resource.getDeclinedReason());
        gateway.setGatewayAdminFirstName(resource.getGatewayAdminFirstName());
        gateway.setGatewayAdminLastName(resource.getGetGatewayAdminLastName());
        gateway.setGatewayAdminEmail(resource.getGatewayAdminEmail());
        gateway.setIdentityServerUserName(resource.getIdentityServerUserName());
        gateway.setIdentityServerPasswordToken(resource.getIdentityServerPasswordToken());
        gateway.setOauthClientId(resource.getOauthClientId());
        gateway.setOauthClientSecret(resource.getOauthClientSecret());
        if (resource.getRequestCreationTime() != null) {
            gateway.setRequestCreationTime(resource.getRequestCreationTime().getTime());
        }
        gateway.setRequesterUsername(resource.getRequesterUsername());
        return gateway;
    }

    public static List<Gateway> getAllGateways(List<ExperimentCatResource> gatewayList) {
        ArrayList<Gateway> gateways = new ArrayList<Gateway>();
        for (ExperimentCatResource resource : gatewayList) {
            gateways.add(ThriftDataModelConversion.getGateway((GatewayResource)resource));
        }
        return gateways;
    }

    public static ExperimentSummaryModel getExperimentSummary(ExperimentSummaryResource experimentSummaryResource) throws RegistryException {
        if (experimentSummaryResource != null) {
            ExperimentSummaryModel experimentSummary = new ExperimentSummaryModel();
            experimentSummary.setProjectId(experimentSummaryResource.getProjectId());
            experimentSummary.setExperimentId(experimentSummaryResource.getExperimentId());
            experimentSummary.setGatewayId(experimentSummaryResource.getGatewayId());
            experimentSummary.setExecutionId(experimentSummaryResource.getExecutionId());
            experimentSummary.setCreationTime(experimentSummaryResource.getCreationTime().getTime());
            experimentSummary.setUserName(experimentSummaryResource.getUserName());
            experimentSummary.setName(experimentSummaryResource.getExperimentName());
            experimentSummary.setDescription(experimentSummaryResource.getDescription());
            experimentSummary.setExperimentStatus(experimentSummaryResource.getState());
            experimentSummary.setResourceHostId(experimentSummaryResource.getResourceHostId());
            return experimentSummary;
        }
        return null;
    }

    public static ExperimentModel getExperiment(ExperimentResource experimentResource) throws RegistryException {
        if (experimentResource != null) {
            UserConfigurationDataResource userConfigurationDataResource;
            List<ExperimentErrorResource> errorDetails;
            ExperimentModel experiment = new ExperimentModel();
            experiment.setProjectId(experimentResource.getProjectId());
            experiment.setExperimentId(experimentResource.getExperimentId());
            experiment.setGatewayId(experimentResource.getGatewayId());
            experiment.setCreationTime(experimentResource.getCreationTime().getTime());
            experiment.setUserName(experimentResource.getUserName());
            experiment.setExperimentName(experimentResource.getExperimentName());
            experiment.setExecutionId(experimentResource.getExecutionId());
            experiment.setDescription(experimentResource.getDescription());
            experiment.setEnableEmailNotification(experimentResource.getEnableEmailNotification());
            experiment.setGatewayExecutionId(experimentResource.getGatewayExecutionId());
            experiment.setGatewayInstanceId(experimentResource.getGatewayInstanceId());
            if (experiment.isEnableEmailNotification()) {
                String notificationEmails = experimentResource.getEmailAddresses();
                experiment.setEmailAddresses(ThriftDataModelConversion.getEmailAddresses(notificationEmails.split(",")));
            }
            List<ExperimentInputResource> experimentInputs = experimentResource.getExperimentInputs();
            experiment.setExperimentInputs(ThriftDataModelConversion.getExpInputs(experimentInputs));
            List<ExperimentOutputResource> experimentOutputs = experimentResource.getExperimentOutputs();
            experiment.setExperimentOutputs(ThriftDataModelConversion.getExpOutputs(experimentOutputs));
            ExperimentStatusResource experimentStatus = experimentResource.getExperimentStatus();
            if (experimentStatus != null) {
                ArrayList<ExperimentStatus> experimentStatuses = new ArrayList<ExperimentStatus>();
                experimentStatuses.add(ThriftDataModelConversion.getExperimentStatus(experimentStatus));
                experiment.setExperimentStatus(experimentStatuses);
            }
            if ((errorDetails = experimentResource.getExperimentErrors()) != null && !errorDetails.isEmpty()) {
                experiment.setErrors(ThriftDataModelConversion.getExperimentErrorList(errorDetails));
            }
            if ((userConfigurationDataResource = experimentResource.getUserConfigurationDataResource()) != null) {
                experiment.setUserConfigurationData(ThriftDataModelConversion.getUserConfigData(userConfigurationDataResource));
            }
            return experiment;
        }
        return null;
    }

    public static InputDataObjectType getInput(Object object) {
        if (object != null) {
            InputDataObjectType dataObjectType = new InputDataObjectType();
            if (object instanceof ExperimentInputResource) {
                ExperimentInputResource inputResource = (ExperimentInputResource)object;
                dataObjectType.setName(inputResource.getInputName());
                dataObjectType.setValue(inputResource.getInputValue());
                dataObjectType.setType(DataType.valueOf((String)inputResource.getDataType()));
                dataObjectType.setApplicationArgument(inputResource.getApplicationArgument());
                dataObjectType.setStandardInput(inputResource.getStandardInput());
                dataObjectType.setUserFriendlyDescription(inputResource.getUserFriendlyDescription());
                dataObjectType.setMetaData(inputResource.getMetadata());
                dataObjectType.setInputOrder(inputResource.getInputOrder().intValue());
                dataObjectType.setIsRequired(inputResource.getIsRequired());
                dataObjectType.setRequiredToAddedToCommandLine(inputResource.getRequiredToAddedToCmd());
                dataObjectType.setDataStaged(inputResource.getDataStaged());
                dataObjectType.setIsReadOnly(inputResource.isReadOnly());
                dataObjectType.setStorageResourceId(inputResource.getStorageResourceId());
                return dataObjectType;
            }
            if (object instanceof ProcessInputResource) {
                ProcessInputResource inputResource = (ProcessInputResource)object;
                dataObjectType.setName(inputResource.getInputName());
                dataObjectType.setValue(inputResource.getInputValue());
                dataObjectType.setType(DataType.valueOf((String)inputResource.getDataType()));
                dataObjectType.setApplicationArgument(inputResource.getApplicationArgument());
                dataObjectType.setStandardInput(inputResource.getStandardInput());
                dataObjectType.setUserFriendlyDescription(inputResource.getUserFriendlyDescription());
                dataObjectType.setMetaData(inputResource.getMetadata());
                dataObjectType.setInputOrder(inputResource.getInputOrder().intValue());
                dataObjectType.setIsRequired(inputResource.getIsRequired());
                dataObjectType.setRequiredToAddedToCommandLine(inputResource.getRequiredToAddedToCmd());
                dataObjectType.setDataStaged(inputResource.getDataStaged());
                dataObjectType.setStorageResourceId(inputResource.getStorageResourceId());
                dataObjectType.setIsReadOnly(inputResource.isReadOnly());
                return dataObjectType;
            }
            return null;
        }
        return null;
    }

    public static OutputDataObjectType getOutput(Object object) {
        if (object != null) {
            OutputDataObjectType dataObjectType = new OutputDataObjectType();
            if (object instanceof ExperimentOutputResource) {
                ExperimentOutputResource outputResource = (ExperimentOutputResource)object;
                dataObjectType.setName(outputResource.getOutputName());
                dataObjectType.setValue(outputResource.getOutputValue());
                dataObjectType.setType(DataType.valueOf((String)outputResource.getDataType()));
                dataObjectType.setApplicationArgument(outputResource.getApplicationArgument());
                dataObjectType.setIsRequired(outputResource.getIsRequired());
                dataObjectType.setRequiredToAddedToCommandLine(outputResource.getRequiredToAddedToCmd());
                dataObjectType.setDataMovement(outputResource.getDataMovement());
                dataObjectType.setLocation(outputResource.getLocation());
                dataObjectType.setSearchQuery(outputResource.getSearchQuery());
                dataObjectType.setOutputStreaming(outputResource.isOutputStreaming());
                dataObjectType.setStorageResourceId(outputResource.getStorageResourceId());
                return dataObjectType;
            }
            if (object instanceof ProcessOutputResource) {
                ProcessOutputResource outputResource = (ProcessOutputResource)object;
                dataObjectType.setName(outputResource.getOutputName());
                dataObjectType.setValue(outputResource.getOutputValue());
                dataObjectType.setType(DataType.valueOf((String)outputResource.getDataType()));
                dataObjectType.setApplicationArgument(outputResource.getApplicationArgument());
                dataObjectType.setIsRequired(outputResource.getIsRequired());
                dataObjectType.setRequiredToAddedToCommandLine(outputResource.getRequiredToAddedToCmd());
                dataObjectType.setDataMovement(outputResource.getDataMovement());
                dataObjectType.setLocation(outputResource.getLocation());
                dataObjectType.setSearchQuery(outputResource.getSearchQuery());
                dataObjectType.setOutputStreaming(outputResource.isOutputStreaming());
                dataObjectType.setStorageResourceId(outputResource.getStorageResourceId());
                return dataObjectType;
            }
            return null;
        }
        return null;
    }

    public static List<String> getEmailAddresses(String[] resourceList) {
        ArrayList<String> emailAddresses = new ArrayList<String>();
        for (String email : resourceList) {
            emailAddresses.add(email);
        }
        return emailAddresses;
    }

    public static List<InputDataObjectType> getExpInputs(List<ExperimentInputResource> exInputList) {
        ArrayList<InputDataObjectType> expInputs = new ArrayList<InputDataObjectType>();
        if (exInputList != null && !exInputList.isEmpty()) {
            for (ExperimentInputResource inputResource : exInputList) {
                InputDataObjectType exInput = ThriftDataModelConversion.getInput(inputResource);
                expInputs.add(exInput);
            }
        }
        return expInputs;
    }

    public static List<OutputDataObjectType> getExpOutputs(List<ExperimentOutputResource> experimentOutputResourceList) {
        ArrayList<OutputDataObjectType> exOutputs = new ArrayList<OutputDataObjectType>();
        if (experimentOutputResourceList != null && !experimentOutputResourceList.isEmpty()) {
            for (ExperimentOutputResource outputResource : experimentOutputResourceList) {
                OutputDataObjectType output = ThriftDataModelConversion.getOutput(outputResource);
                exOutputs.add(output);
            }
        }
        return exOutputs;
    }

    public static List<InputDataObjectType> getProcessInputs(List<ProcessInputResource> processInputResources) {
        ArrayList<InputDataObjectType> nodeInputs = new ArrayList<InputDataObjectType>();
        if (processInputResources != null && !processInputResources.isEmpty()) {
            for (ProcessInputResource inputResource : processInputResources) {
                InputDataObjectType nodeInput = ThriftDataModelConversion.getInput(inputResource);
                nodeInputs.add(nodeInput);
            }
        }
        return nodeInputs;
    }

    public static List<OutputDataObjectType> getProcessOutputs(List<ProcessOutputResource> processOutputResources) {
        ArrayList<OutputDataObjectType> processOutputs = new ArrayList<OutputDataObjectType>();
        if (processOutputResources != null && !processOutputResources.isEmpty()) {
            for (ProcessOutputResource outputResource : processOutputResources) {
                OutputDataObjectType output = ThriftDataModelConversion.getOutput(outputResource);
                processOutputs.add(output);
            }
        }
        return processOutputs;
    }

    public static ExperimentStatus getExperimentStatus(ExperimentStatusResource status) {
        if (status != null) {
            ExperimentStatus experimentStatus = new ExperimentStatus();
            experimentStatus.setState(ExperimentState.valueOf((String)status.getState()));
            Timestamp timeOfStateChange = status.getTimeOfStateChange();
            if (timeOfStateChange == null) {
                timeOfStateChange = AiravataUtils.getCurrentTimestamp();
            }
            experimentStatus.setTimeOfStateChange(timeOfStateChange.getTime());
            experimentStatus.setReason(status.getReason());
            return experimentStatus;
        }
        return null;
    }

    public static ProcessStatus getProcessStatus(ProcessStatusResource status) {
        if (status != null) {
            ProcessStatus processStatus = new ProcessStatus();
            processStatus.setState(ProcessState.valueOf((String)status.getState()));
            Timestamp timeOfStateChange = status.getTimeOfStateChange();
            if (timeOfStateChange == null) {
                timeOfStateChange = AiravataUtils.getCurrentTimestamp();
            }
            processStatus.setTimeOfStateChange(timeOfStateChange.getTime());
            processStatus.setReason(status.getReason());
            return processStatus;
        }
        return null;
    }

    public static TaskStatus getTaskStatus(TaskStatusResource status) {
        if (status != null) {
            TaskStatus taskStatus = new TaskStatus();
            taskStatus.setState(TaskState.valueOf((String)status.getState()));
            Timestamp timeOfStateChange = status.getTimeOfStateChange();
            if (timeOfStateChange == null) {
                timeOfStateChange = AiravataUtils.getCurrentTimestamp();
            }
            taskStatus.setTimeOfStateChange(timeOfStateChange.getTime());
            taskStatus.setReason(status.getReason());
            return taskStatus;
        }
        return null;
    }

    public static JobStatus getJobStatus(JobStatusResource status) {
        if (status != null) {
            JobStatus jobStatus = new JobStatus();
            jobStatus.setJobState(JobState.valueOf((String)status.getState()));
            Timestamp timeOfStateChange = status.getTimeOfStateChange();
            if (timeOfStateChange == null) {
                timeOfStateChange = AiravataUtils.getCurrentTimestamp();
            }
            jobStatus.setTimeOfStateChange(timeOfStateChange.getTime());
            jobStatus.setReason(status.getReason());
            return jobStatus;
        }
        return null;
    }

    public static ProcessModel getProcessModel(ProcessResource processResource) throws RegistryException {
        if (processResource != null) {
            ComputationalResourceSchedulingModel schedule;
            ProcessStatus processStatus;
            ProcessModel processModel = new ProcessModel();
            processModel.setProcessId(processResource.getProcessId());
            processModel.setExperimentId(processResource.getExperimentId());
            processModel.setCreationTime(processResource.getCreationTime().getTime());
            processModel.setLastUpdateTime(processResource.getLastUpdateTime().getTime());
            processModel.setProcessDetail(processResource.getProcessDetail());
            processModel.setApplicationInterfaceId(processResource.getApplicationInterfaceId());
            processModel.setTaskDag(processResource.getTaskDag());
            processModel.setGatewayExecutionId(processResource.getGatewayExecutionId());
            processModel.setApplicationDeploymentId(processResource.getApplicationDeploymentId());
            processModel.setComputeResourceId(processResource.getComputeResourceId());
            processModel.setEnableEmailNotification(processResource.getEnableEmailNotification());
            processModel.setExperimentDataDir(processResource.getExperimentDataDir());
            processModel.setUseUserCRPref(processResource.isUseUserCRPref());
            if (processModel.isEnableEmailNotification()) {
                String notificationEmails = processResource.getEmailAddresses();
                processModel.setEmailAddresses(ThriftDataModelConversion.getEmailAddresses(notificationEmails.split(",")));
            }
            processModel.setProcessInputs(ThriftDataModelConversion.getProcessInputs(processResource.getProcessInputs()));
            processModel.setProcessOutputs(ThriftDataModelConversion.getProcessOutputs(processResource.getProcessOutputs()));
            ErrorModel errorModel = ThriftDataModelConversion.getErrorModel(processResource.getProcessError());
            if (errorModel != null) {
                ArrayList<ErrorModel> errorModels = new ArrayList<ErrorModel>();
                errorModels.add(errorModel);
                processModel.setProcessErrors(errorModels);
            }
            if ((processStatus = ThriftDataModelConversion.getProcessStatus(processResource.getProcessStatus())) != null) {
                ArrayList<ProcessStatus> statuses = new ArrayList<ProcessStatus>();
                statuses.add(processStatus);
                processModel.setProcessStatuses(statuses);
            }
            if ((schedule = ThriftDataModelConversion.getProcessResourceSchedule(processResource.getProcessResourceSchedule())) != null) {
                processModel.setProcessResourceSchedule(schedule);
            }
            processModel.setTasks(ThriftDataModelConversion.getTaskModelList(processResource.getTaskList()));
            processModel.setStorageResourceId(processResource.getStorageResourceId());
            processModel.setUserDn(processResource.getUserDn());
            processModel.setGenerateCert(processResource.isGenerateCert());
            processModel.setUserName(processResource.getUserName());
            return processModel;
        }
        return null;
    }

    public static List<TaskModel> getTaskModelList(List<TaskResource> resources) throws RegistryException {
        ArrayList<TaskModel> taskDetailsList = new ArrayList<TaskModel>();
        if (resources != null && !resources.isEmpty()) {
            for (TaskResource resource : resources) {
                taskDetailsList.add(ThriftDataModelConversion.getTaskModel(resource));
            }
        }
        return taskDetailsList;
    }

    public static TaskModel getTaskModel(TaskResource taskResource) throws RegistryException {
        ErrorModel errorModel;
        TaskModel model = new TaskModel();
        model.setTaskId(taskResource.getTaskId());
        model.setTaskType(TaskTypes.valueOf((String)taskResource.getTaskType()));
        model.setParentProcessId(taskResource.getParentProcessId());
        model.setCreationTime(taskResource.getCreationTime().getTime());
        model.setLastUpdateTime(taskResource.getLastUpdateTime().getTime());
        model.setTaskDetail(taskResource.getTaskDetail());
        model.setSubTaskModel(taskResource.getSubTaskModel());
        TaskStatus taskStatus = ThriftDataModelConversion.getTaskStatus(taskResource.getTaskStatus());
        if (taskStatus != null) {
            ArrayList<TaskStatus> taskStatuses = new ArrayList<TaskStatus>();
            taskStatuses.add(taskStatus);
            model.setTaskStatuses(taskStatuses);
        }
        if ((errorModel = ThriftDataModelConversion.getErrorModel(taskResource.getTaskError())) != null) {
            ArrayList<ErrorModel> errors = new ArrayList<ErrorModel>();
            errors.add(errorModel);
            model.setTaskErrors(errors);
        }
        return model;
    }

    public static JobModel getJobModel(JobResource jobResource) throws RegistryException {
        JobModel model = new JobModel();
        model.setJobId(jobResource.getJobId());
        model.setProcessId(jobResource.getProcessId());
        model.setTaskId(jobResource.getTaskId());
        model.setJobDescription(jobResource.getJobDescription());
        model.setCreationTime(jobResource.getCreationTime().getTime());
        model.setComputeResourceConsumed(jobResource.getComputeResourceConsumed());
        model.setJobName(jobResource.getJobName());
        model.setWorkingDir(jobResource.getWorkingDir());
        JobStatus jobStatus = ThriftDataModelConversion.getJobStatus(jobResource.getJobStatus());
        if (jobStatus != null) {
            ArrayList<JobStatus> jobStatuses = new ArrayList<JobStatus>();
            jobStatuses.add(jobStatus);
            model.setJobStatuses(jobStatuses);
        }
        model.setExitCode(jobResource.getExitCode());
        model.setStdOut(jobResource.getStdOut());
        model.setStdErr(jobResource.getStdErr());
        return model;
    }

    public static ErrorModel getErrorModel(Object object) {
        if (object != null) {
            ErrorModel errorModel = new ErrorModel();
            if (object instanceof ExperimentErrorResource) {
                ExperimentErrorResource errorResource = (ExperimentErrorResource)object;
                errorModel.setErrorId(errorResource.getErrorId());
                errorModel.setCreationTime(errorResource.getCreationTime().getTime());
                errorModel.setActualErrorMessage(errorResource.getActualErrorMessage());
                errorModel.setUserFriendlyMessage(errorResource.getUserFriendlyMessage());
                errorModel.setTransientOrPersistent(errorResource.getTransientOrPersistent());
                String rootCauseErrorIdList = errorResource.getRootCauseErrorIdList();
                if (rootCauseErrorIdList != null) {
                    errorModel.setRootCauseErrorIdList(Arrays.asList(rootCauseErrorIdList.split(",")));
                }
                return errorModel;
            }
            if (object instanceof ProcessErrorResource) {
                ProcessErrorResource errorResource = (ProcessErrorResource)object;
                errorModel.setErrorId(errorResource.getErrorId());
                errorModel.setCreationTime(errorResource.getCreationTime().getTime());
                errorModel.setActualErrorMessage(errorResource.getActualErrorMessage());
                errorModel.setUserFriendlyMessage(errorResource.getUserFriendlyMessage());
                errorModel.setTransientOrPersistent(errorResource.getTransientOrPersistent());
                String rootCauseErrorIdList = errorResource.getRootCauseErrorIdList();
                if (rootCauseErrorIdList != null) {
                    errorModel.setRootCauseErrorIdList(Arrays.asList(rootCauseErrorIdList.split(",")));
                }
                return errorModel;
            }
            if (object instanceof TaskErrorResource) {
                TaskErrorResource errorResource = (TaskErrorResource)object;
                errorModel.setErrorId(errorResource.getErrorId());
                errorModel.setCreationTime(errorResource.getCreationTime().getTime());
                errorModel.setActualErrorMessage(errorResource.getActualErrorMessage());
                errorModel.setUserFriendlyMessage(errorResource.getUserFriendlyMessage());
                errorModel.setTransientOrPersistent(errorResource.getTransientOrPersistent());
                String rootCauseErrorIdList = errorResource.getRootCauseErrorIdList();
                if (rootCauseErrorIdList != null) {
                    errorModel.setRootCauseErrorIdList(Arrays.asList(rootCauseErrorIdList.split(",")));
                }
                return errorModel;
            }
            return null;
        }
        return null;
    }

    public static List<ErrorModel> getExperimentErrorList(List<ExperimentErrorResource> errorResources) {
        ArrayList<ErrorModel> errorList = new ArrayList<ErrorModel>();
        if (errorResources != null && !errorResources.isEmpty()) {
            for (ExperimentErrorResource errorResource : errorResources) {
                errorList.add(ThriftDataModelConversion.getErrorModel(errorResource));
            }
        }
        return errorList;
    }

    public static UserConfigurationDataModel getUserConfigData(UserConfigurationDataResource resource) throws RegistryException {
        if (resource != null) {
            UserConfigurationDataModel data = new UserConfigurationDataModel();
            data.setAiravataAutoSchedule(resource.getAiravataAutoSchedule());
            data.setOverrideManualScheduledParams(resource.getOverrideManualScheduledParams());
            data.setShareExperimentPublicly(resource.getShareExperimentPublically());
            data.setUserDN(resource.getUserDn());
            data.setGenerateCert(resource.getGenerateCert());
            data.setStorageId(resource.getStorageId());
            data.setExperimentDataDir(resource.getExperimentDataDir());
            data.setUseUserCRPref(resource.getUseUserCRPref());
            ComputationalResourceSchedulingModel resourceSchedulingModel = new ComputationalResourceSchedulingModel();
            resourceSchedulingModel.setResourceHostId(resource.getResourceHostId());
            resourceSchedulingModel.setTotalCPUCount(resource.getTotalCpuCount().intValue());
            resourceSchedulingModel.setNodeCount(resource.getNodeCount().intValue());
            resourceSchedulingModel.setNumberOfThreads(resource.getNumberOfThreads().intValue());
            resourceSchedulingModel.setQueueName(resource.getQueueName());
            resourceSchedulingModel.setWallTimeLimit(resource.getWallTimeLimit().intValue());
            resourceSchedulingModel.setTotalPhysicalMemory(resource.getTotalPhysicalMemory().intValue());
            resourceSchedulingModel.setStaticWorkingDir(resource.getStaticWorkingDir());
            resourceSchedulingModel.setOverrideLoginUserName(resource.getOverrideLoginUserName());
            resourceSchedulingModel.setOverrideScratchLocation(resource.getOverrideScratchLocation());
            resourceSchedulingModel.setOverrideAllocationProjectNumber(resource.getOverrideAllocationProjectNumber());
            data.setComputationalResourceScheduling(resourceSchedulingModel);
            return data;
        }
        return null;
    }

    public static ComputationalResourceSchedulingModel getProcessResourceSchedule(ProcessResourceScheduleResource resource) {
        if (resource != null) {
            ComputationalResourceSchedulingModel resourceSchedulingModel = new ComputationalResourceSchedulingModel();
            resourceSchedulingModel.setResourceHostId(resource.getResourceHostId());
            resourceSchedulingModel.setTotalCPUCount(resource.getTotalCpuCount().intValue());
            resourceSchedulingModel.setNodeCount(resource.getNodeCount().intValue());
            resourceSchedulingModel.setNumberOfThreads(resource.getNumberOfThreads().intValue());
            resourceSchedulingModel.setQueueName(resource.getQueueName());
            resourceSchedulingModel.setWallTimeLimit(resource.getWallTimeLimit().intValue());
            resourceSchedulingModel.setTotalPhysicalMemory(resource.getTotalPhysicalMemory().intValue());
            resourceSchedulingModel.setStaticWorkingDir(resource.getStaticWorkingDir());
            resourceSchedulingModel.setOverrideLoginUserName(resource.getOverrideLoginUserName());
            resourceSchedulingModel.setOverrideScratchLocation(resource.getOverrideScratchLocation());
            resourceSchedulingModel.setOverrideAllocationProjectNumber(resource.getOverrideAllocationProjectNumber());
            return resourceSchedulingModel;
        }
        return null;
    }

    public static ComputationalResourceSchedulingModel getComputationalResourceScheduling(UserConfigurationDataResource resource) {
        if (resource != null) {
            ComputationalResourceSchedulingModel resourceSchedulingModel = new ComputationalResourceSchedulingModel();
            resourceSchedulingModel.setResourceHostId(resource.getResourceHostId());
            resourceSchedulingModel.setTotalCPUCount(resource.getTotalCpuCount().intValue());
            resourceSchedulingModel.setNodeCount(resource.getNodeCount().intValue());
            resourceSchedulingModel.setNumberOfThreads(resource.getNumberOfThreads().intValue());
            resourceSchedulingModel.setQueueName(resource.getQueueName());
            resourceSchedulingModel.setWallTimeLimit(resource.getWallTimeLimit().intValue());
            resourceSchedulingModel.setTotalPhysicalMemory(resource.getTotalPhysicalMemory().intValue());
            resourceSchedulingModel.setStaticWorkingDir(resource.getStaticWorkingDir());
            resourceSchedulingModel.setOverrideLoginUserName(resource.getOverrideLoginUserName());
            resourceSchedulingModel.setOverrideScratchLocation(resource.getOverrideScratchLocation());
            resourceSchedulingModel.setOverrideAllocationProjectNumber(resource.getOverrideAllocationProjectNumber());
            return resourceSchedulingModel;
        }
        return null;
    }

    public static Notification getNotification(NotificationResource resource) {
        if (resource != null) {
            Notification notification = new Notification();
            notification.setNotificationId(resource.getNotificationId());
            notification.setGatewayId(resource.getGatewayId());
            notification.setTitle(resource.getTitle());
            notification.setNotificationMessage(resource.getNotificationMessage());
            notification.setPriority(NotificationPriority.valueOf((String)resource.getPriority()));
            if (resource.getPublishedTime() != null) {
                notification.setPublishedTime(resource.getPublishedTime().getTime());
            }
            if (resource.getExpirationTime() != null) {
                notification.setExpirationTime(resource.getExpirationTime().getTime());
            }
            if (resource.getCreationTime() != null) {
                notification.setCreationTime(resource.getCreationTime().getTime());
            }
            return notification;
        }
        return null;
    }
}

