/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.server;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.net.URI;

public class ServiceTransaction
extends BasicTransaction {
    public boolean authGrantValid;
    public boolean accessTokenValid;
    URI callback;
    Client client;
    long lifetime = 0L;
    String username;
    String certReqString;
    transient MyPKCS10CertRequest certReq;

    public ServiceTransaction(Identifier identifier) {
        super(identifier);
    }

    public ServiceTransaction(AuthorizationGrant ag) {
        super(ag);
    }

    public boolean isAuthGrantValid() {
        return this.authGrantValid;
    }

    public void setAuthGrantValid(boolean authGrantValid) {
        this.authGrantValid = authGrantValid;
    }

    public boolean isAccessTokenValid() {
        return this.accessTokenValid;
    }

    public void setAccessTokenValid(boolean accessTokenValid) {
        this.accessTokenValid = accessTokenValid;
    }

    public URI getCallback() {
        return this.callback;
    }

    public void setCallback(URI callback) {
        this.callback = callback;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public MyPKCS10CertRequest getCertReq() {
        if (this.certReq != null) {
            return this.certReq;
        }
        if (this.certReqString == null) {
            return null;
        }
        return CertUtil.fromStringToCertReq((String)this.getCertReqString());
    }

    public void setCertReqString(String certReqString) {
        if (certReqString == null && this.certReq != null) {
            certReqString = CertUtil.fromCertReqToString((MyPKCS10CertRequest)this.certReq);
        }
        this.certReqString = certReqString;
    }

    public String getCertReqString() {
        return this.certReqString;
    }

    public void setCertReq(String certReq) {
        this.certReqString = certReq;
    }

    public void setCertReq(MyPKCS10CertRequest certReq) {
        this.certReq = certReq;
        this.certReqString = CertUtil.fromCertReqToString((MyPKCS10CertRequest)certReq);
    }

    public String toString() {
        String out = ((Object)((Object)this)).getClass().getSimpleName() + "[";
        out = out + "id=" + this.getIdentifierString() + ", authGrant=" + this.getAuthorizationGrant() + "(" + (this.isAuthGrantValid() ? "" : "in") + "valid)";
        out = out + ", verifier=" + (!this.hasVerifier() ? "(none)" : this.getVerifier());
        out = out + ", access token=" + this.getAccessToken() + "(" + (this.isAccessTokenValid() ? "" : "in") + "valid)";
        out = out + ", lifetime=" + this.getLifetime();
        return out + "]";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ServiceTransaction)) {
            return false;
        }
        ServiceTransaction st = (ServiceTransaction)((Object)obj);
        if (this.isAuthGrantValid() != st.isAuthGrantValid()) {
            return false;
        }
        if (this.isAccessTokenValid() != st.isAccessTokenValid()) {
            return false;
        }
        return this.getLifetime() == st.getLifetime();
    }
}

