/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.support;

import org.apache.lucene.store.jdbc.dialect.Dialect;

public class JdbcColumn {
    private Dialect dialect;
    private String name;
    private int index;
    private String type;
    private boolean quoted = false;

    public JdbcColumn(Dialect dialect, String name, int index, String type) {
        this.dialect = dialect;
        this.setName(name);
        this.index = index;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        if (name.charAt(0) == this.dialect.openQuote()) {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    public String getQuotedName() {
        return this.quoted ? this.dialect.openQuote() + this.name + this.dialect.closeQuote() : this.name;
    }
}

