/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.compass.core.CompassTermFreq;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineTermFrequencies;
import org.compass.core.impl.DefaultCompassTermFreq;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;

public class LuceneSearchEngineTermFrequencies
implements SearchEngineTermFrequencies {
    private CompassTermFreq[] termFreqs;

    public LuceneSearchEngineTermFrequencies(String[] propertyNames, int size, LuceneSearchEngineInternalSearch internalSearch) throws SearchEngineException {
        if (internalSearch.isEmpty()) {
            this.termFreqs = new CompassTermFreq[0];
            return;
        }
        PriorityQueue<CompassTermFreq> queue = new PriorityQueue<CompassTermFreq>(10, new Comparator<CompassTermFreq>(){

            @Override
            public int compare(CompassTermFreq a, CompassTermFreq b) {
                return (int)(b.getFreq() - a.getFreq());
            }
        });
        block9: for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            TermEnum termEnum = null;
            try {
                termEnum = internalSearch.getReader().terms(new Term(propertyName, ""));
                while (termEnum.term() != null && propertyName.equals(termEnum.term().field())) {
                    queue.add(new DefaultCompassTermFreq(termEnum.term().text(), termEnum.docFreq(), propertyName));
                    if (termEnum.next()) continue;
                    continue block9;
                }
                continue;
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to get term freq for proeprty [" + propertyName + "]", e);
            }
            finally {
                if (termEnum != null) {
                    try {
                        termEnum.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        int retSize = size;
        if (queue.size() < size) {
            retSize = queue.size();
        }
        this.termFreqs = new CompassTermFreq[retSize];
        for (int i = 0; i < this.termFreqs.length; ++i) {
            this.termFreqs[i] = queue.poll();
        }
    }

    public CompassTermFreq[] getTerms() {
        return this.termFreqs;
    }
}

