/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similar.MoreLikeThis;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.util.LuceneUtils;

public class LuceneSearchEngineMoreLikeThisQueryBuilder
implements SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder {
    private LuceneSearchEngine searchEngine;
    private Reader reader;
    private Resource idResource;
    private LuceneResource resource;
    private MoreLikeThis moreLikeThis;
    private String[] subIndexes;
    private String[] aliases;
    private boolean propertiesSet;

    public LuceneSearchEngineMoreLikeThisQueryBuilder(LuceneSearchEngine searchEngine, Resource idResource) {
        this.idResource = idResource;
        this.resource = (LuceneResource)searchEngine.load(idResource);
        this.init(searchEngine);
    }

    public LuceneSearchEngineMoreLikeThisQueryBuilder(LuceneSearchEngine searchEngine, Reader reader) {
        this.reader = reader;
        this.init(searchEngine);
    }

    private void init(LuceneSearchEngine searchEngine) {
        this.searchEngine = searchEngine;
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)searchEngine.internalSearch(this.subIndexes, this.aliases);
        this.moreLikeThis = new MoreLikeThis(internalSearch.getReader());
        this.moreLikeThis.setFieldNames(null);
        this.moreLikeThis.setAnalyzer(searchEngine.getSearchEngineFactory().getAnalyzerManager().getSearchAnalyzer());
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setSubIndexes(String[] subIndexes) {
        this.subIndexes = subIndexes;
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)this.searchEngine.internalSearch(subIndexes, this.aliases);
        MoreLikeThis moreLikeThis = new MoreLikeThis(internalSearch.getReader());
        this.copy(moreLikeThis);
        this.moreLikeThis = moreLikeThis;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setAliases(String[] aliases) {
        this.aliases = aliases;
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)this.searchEngine.internalSearch(this.subIndexes, aliases);
        MoreLikeThis moreLikeThis = new MoreLikeThis(internalSearch.getReader());
        this.copy(moreLikeThis);
        this.moreLikeThis = moreLikeThis;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setProperties(String[] properties) {
        this.propertiesSet = true;
        this.moreLikeThis.setFieldNames(properties);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder addProperty(String property) {
        this.propertiesSet = true;
        if (this.moreLikeThis.getFieldNames() == null) {
            this.moreLikeThis.setFieldNames(new String[]{property});
        } else {
            String[] newNames = new String[this.moreLikeThis.getFieldNames().length + 1];
            System.arraycopy(this.moreLikeThis.getFieldNames(), 0, newNames, 0, this.moreLikeThis.getFieldNames().length);
            newNames[newNames.length - 1] = property;
            this.moreLikeThis.setFieldNames(newNames);
        }
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setAnalyzer(String analyzer) {
        this.moreLikeThis.setAnalyzer(this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerMustExist(analyzer));
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setBoost(boolean boost) {
        this.moreLikeThis.setBoost(boost);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setMaxNumTokensParsed(int maxNumTokensParsed) {
        this.moreLikeThis.setMaxNumTokensParsed(maxNumTokensParsed);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setMaxQueryTerms(int maxQueryTerms) {
        this.moreLikeThis.setMaxQueryTerms(maxQueryTerms);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setMaxWordLen(int maxWordLen) {
        this.moreLikeThis.setMaxWordLen(maxWordLen);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setMinResourceFreq(int minDocFreq) {
        this.moreLikeThis.setMinDocFreq(minDocFreq);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setMinTermFreq(int minTermFreq) {
        this.moreLikeThis.setMinTermFreq(minTermFreq);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setMinWordLen(int minWordLen) {
        this.moreLikeThis.setMinWordLen(minWordLen);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineMoreLikeThisQueryBuilder setStopWords(String[] stopWords) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(stopWords));
        this.moreLikeThis.setStopWords(set);
        return this;
    }

    public SearchEngineQuery toQuery() {
        if (!this.propertiesSet) {
            this.moreLikeThis.setFieldNames(new String[]{this.searchEngine.getSearchEngineFactory().getAllProperty()});
        }
        try {
            Query query;
            if (this.reader != null) {
                query = this.moreLikeThis.like(this.reader);
            } else {
                BooleanQuery boolQuery = new BooleanQuery();
                boolQuery.add(this.moreLikeThis.like(this.resource.getDocNum()), BooleanClause.Occur.MUST);
                boolQuery.add(LuceneUtils.buildResourceLoadQuery(this.resource.resourceKey()), BooleanClause.Occur.MUST_NOT);
                query = boolQuery;
            }
            return new LuceneSearchEngineQuery(this.searchEngine, query);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to find queries like [" + this.idResource + "]", e);
        }
    }

    private void copy(MoreLikeThis moreLikeThis) {
        moreLikeThis.setAnalyzer(this.moreLikeThis.getAnalyzer());
        moreLikeThis.setBoost(this.moreLikeThis.isBoost());
        moreLikeThis.setFieldNames(this.moreLikeThis.getFieldNames());
        moreLikeThis.setMaxNumTokensParsed(this.moreLikeThis.getMaxNumTokensParsed());
        moreLikeThis.setMaxQueryTerms(this.moreLikeThis.getMaxQueryTerms());
        moreLikeThis.setMaxWordLen(this.moreLikeThis.getMaxWordLen());
        moreLikeThis.setMinDocFreq(this.moreLikeThis.getMinDocFreq());
        moreLikeThis.setMinTermFreq(this.moreLikeThis.getMinTermFreq());
        moreLikeThis.setMinWordLen(this.moreLikeThis.getMinWordLen());
        moreLikeThis.setStopWords(this.moreLikeThis.getStopWords());
    }
}

