/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.spellcheck;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.CompassSpellChecker;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.spellcheck.SearchEngineSpellCheckSuggestBuilder;
import org.compass.core.engine.spellcheck.SearchEngineSpellSuggestions;
import org.compass.core.lucene.engine.spellcheck.DefaultLuceneSearchEngineSpellSuggestions;
import org.compass.core.lucene.engine.spellcheck.InternalLuceneSearchEngineSpellCheckManager;
import org.compass.core.lucene.engine.spellcheck.SpellCheckerCallback;
import org.compass.core.mapping.ResourceMapping;

public class DefaultLuceneSearchEngineSpellCheckSuggestBuilder
implements SearchEngineSpellCheckSuggestBuilder {
    private InternalLuceneSearchEngineSpellCheckManager spellCheckerManager;
    private String word;
    private int numberOfSuggestions = 1;
    private String[] subIndexes;
    private String[] aliases;
    private String restrictToProperty;
    private boolean morePopular;
    private float accuracy = 0.5f;

    public DefaultLuceneSearchEngineSpellCheckSuggestBuilder(String word, InternalLuceneSearchEngineSpellCheckManager spellCheckerManager) {
        this.word = word;
        this.spellCheckerManager = spellCheckerManager;
        this.accuracy = spellCheckerManager.getDefaultAccuracy();
    }

    public SearchEngineSpellCheckSuggestBuilder subIndexes(String ... subIndexes) {
        this.subIndexes = subIndexes;
        return this;
    }

    public SearchEngineSpellCheckSuggestBuilder aliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public SearchEngineSpellCheckSuggestBuilder types(Class ... types) {
        if (types == null) {
            this.aliases = null;
            return this;
        }
        String[] aliases = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ResourceMapping resourceMapping = this.spellCheckerManager.getMapping().getRootMappingByClass(types[i]);
            aliases[i] = resourceMapping.getAlias();
        }
        this.aliases(aliases);
        return this;
    }

    public SearchEngineSpellCheckSuggestBuilder numberOfSuggestions(int numberOfSuggestions) {
        this.numberOfSuggestions = numberOfSuggestions;
        return this;
    }

    public SearchEngineSpellCheckSuggestBuilder restrictToProperty(String restrictToProperty) {
        this.restrictToProperty = restrictToProperty;
        return this;
    }

    public SearchEngineSpellCheckSuggestBuilder morePopular(boolean morePopular) {
        this.morePopular = morePopular;
        return this;
    }

    public SearchEngineSpellCheckSuggestBuilder accuracy(float accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public SearchEngineSpellSuggestions suggest() {
        return this.spellCheckerManager.execute(this.subIndexes, this.aliases, new SpellCheckerCallback<SearchEngineSpellSuggestions>(){

            @Override
            public SearchEngineSpellSuggestions execute(CompassSpellChecker spellChecker, IndexReader reader) throws SearchEngineException {
                if (DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.morePopular && DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.restrictToProperty == null) {
                    DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.restrictToProperty = DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.spellCheckerManager.getDefaultProperty();
                }
                if (spellChecker == null) {
                    return new DefaultLuceneSearchEngineSpellSuggestions(false, new String[0]);
                }
                spellChecker.setAccuracy(DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.accuracy);
                try {
                    if (DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.restrictToProperty == null) {
                        reader = null;
                    }
                    String[] suggestions = spellChecker.suggestSimilar(DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.word, DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.numberOfSuggestions, reader, DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.restrictToProperty, DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.morePopular);
                    return new DefaultLuceneSearchEngineSpellSuggestions(spellChecker.exist(DefaultLuceneSearchEngineSpellCheckSuggestBuilder.this.word), suggestions);
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to suggest spell check", e);
                }
            }
        });
    }
}

