/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import org.compass.core.Property;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.SpellCheckType;
import org.compass.core.util.Parameter;

public interface ResourcePropertyMapping
extends Mapping {
    public String getAnalyzer();

    public String getRootAlias();

    public boolean isInternal();

    public float getBoost();

    public Boolean isOmitNorms();

    public ExcludeFromAllType getExcludeFromAll();

    public SpellCheckType getSpellCheck();

    public Property.Store getStore();

    public Property.Index getIndex();

    public Property.TermVector getTermVector();

    public ReverseType getReverse();

    public String getNullValue();

    public boolean hasNullValue();

    public static class ExcludeFromAllType
    extends Parameter {
        public static final ExcludeFromAllType NO = new ExcludeFromAllType("NO");
        public static final ExcludeFromAllType YES = new ExcludeFromAllType("YES");
        public static final ExcludeFromAllType NO_ANALYZED = new ExcludeFromAllType("NO_ANALYZED");

        protected ExcludeFromAllType(String name) {
            super(name);
        }

        public static ExcludeFromAllType fromString(String excludeFromAllType) {
            if ("no".equalsIgnoreCase(excludeFromAllType) || "false".equalsIgnoreCase(excludeFromAllType)) {
                return NO;
            }
            if ("yes".equalsIgnoreCase(excludeFromAllType) || "true".equalsIgnoreCase(excludeFromAllType)) {
                return YES;
            }
            if ("no_analyzed".equalsIgnoreCase(excludeFromAllType)) {
                return NO_ANALYZED;
            }
            throw new IllegalArgumentException("Can't find exclude from all type for [" + excludeFromAllType + "]");
        }

        public static String toString(ExcludeFromAllType excludeFromAllType) {
            if (excludeFromAllType == NO) {
                return "no";
            }
            if (excludeFromAllType == NO_ANALYZED) {
                return "no_analyzed";
            }
            if (excludeFromAllType == YES) {
                return "yes";
            }
            return "no";
        }
    }

    public static class ReverseType
    extends Parameter {
        private static final long serialVersionUID = 9135849961654313364L;
        public static final ReverseType NO = new ReverseType("NO");
        public static final ReverseType READER = new ReverseType("READER");
        public static final ReverseType STRING = new ReverseType("STRING");

        protected ReverseType(String name) {
            super(name);
        }

        public static ReverseType fromString(String reverseType) {
            if ("no".equalsIgnoreCase(reverseType)) {
                return NO;
            }
            if ("reader".equalsIgnoreCase(reverseType)) {
                return READER;
            }
            if ("string".equalsIgnoreCase(reverseType)) {
                return STRING;
            }
            throw new IllegalArgumentException("Can't find reverse type for [" + reverseType + "]");
        }
    }
}

