/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.datasource;

import com.gigaspaces.datasource.BulkDataPersister;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataPersister;
import com.gigaspaces.datasource.DataSourceException;
import java.util.List;
import java.util.Properties;
import org.compass.core.Compass;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.spi.InternalCompass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompassDataSource
implements DataPersister<Object>,
BulkDataPersister {
    public static final String COMPASS_CFG_PROPERTY = "compass-config-file";
    private Compass compass;
    private CompassTemplate compassTemplate;

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public void init(Properties properties) throws DataSourceException {
        if (this.compass == null) {
            String compassConfig = properties.getProperty(COMPASS_CFG_PROPERTY);
            this.compass = CompassConfigurationFactory.newConfiguration().configure(compassConfig).buildCompass();
        }
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    public void shutdown() throws DataSourceException {
        if (this.compass != null) {
            this.compass.close();
            this.compass = null;
        }
    }

    public void write(Object object) throws DataSourceException {
        if (this.hasMapping(object)) {
            this.compassTemplate.save(object);
        }
    }

    public void update(Object object) throws DataSourceException {
        if (this.hasMapping(object)) {
            this.compassTemplate.save(object);
        }
    }

    public void remove(Object object) throws DataSourceException {
        if (this.hasMapping(object)) {
            this.compassTemplate.delete(object);
        }
    }

    public void writeBatch(final List<Object> objects) throws DataSourceException {
        this.compassTemplate.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                for (Object object : objects) {
                    if (!CompassDataSource.this.hasMapping(object)) continue;
                    session.save(object);
                }
            }
        });
    }

    public void updateBatch(final List<Object> objects) throws DataSourceException {
        this.compassTemplate.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                for (Object object : objects) {
                    if (!CompassDataSource.this.hasMapping(object)) continue;
                    session.save(object);
                }
            }
        });
    }

    public void removeBatch(final List<Object> objects) throws DataSourceException {
        this.compassTemplate.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                for (Object object : objects) {
                    if (!CompassDataSource.this.hasMapping(object)) continue;
                    session.delete(object);
                }
            }
        });
    }

    public void executeBulk(final List<BulkItem> bulkItems) throws DataSourceException {
        this.compassTemplate.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                for (BulkItem bulkItem : bulkItems) {
                    switch (bulkItem.getOperation()) {
                        case 1: {
                            if (!CompassDataSource.this.hasMapping(bulkItem.getItem())) break;
                            session.delete(bulkItem.getItem());
                            break;
                        }
                        case 3: {
                            if (!CompassDataSource.this.hasMapping(bulkItem.getItem())) break;
                            session.save(bulkItem.getItem());
                            break;
                        }
                        case 2: {
                            if (!CompassDataSource.this.hasMapping(bulkItem.getItem())) break;
                            session.save(bulkItem.getItem());
                            break;
                        }
                    }
                }
            }
        });
    }

    public Object read(Object template) throws DataSourceException {
        throw new UnsupportedOperationException();
    }

    public DataIterator<Object> iterator(Object template) throws DataSourceException {
        throw new UnsupportedOperationException();
    }

    public int count(Object template) throws DataSourceException {
        throw new UnsupportedOperationException();
    }

    public DataIterator<Object> initialLoad() throws DataSourceException {
        throw new UnsupportedOperationException();
    }

    private boolean hasMapping(Object object) {
        return ((InternalCompass)this.compass).getMapping().getRootMappingByClass(object.getClass()) != null;
    }
}

