/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.CaptionFormat;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Captions
implements Serializable {
    private String mergePolicy;
    private ListWithAutoConstructFlag<CaptionSource> captionSources;
    private ListWithAutoConstructFlag<CaptionFormat> captionFormats;

    public String getMergePolicy() {
        return this.mergePolicy;
    }

    public void setMergePolicy(String mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public Captions withMergePolicy(String mergePolicy) {
        this.mergePolicy = mergePolicy;
        return this;
    }

    public List<CaptionSource> getCaptionSources() {
        if (this.captionSources == null) {
            this.captionSources = new ListWithAutoConstructFlag();
            this.captionSources.setAutoConstruct(true);
        }
        return this.captionSources;
    }

    public void setCaptionSources(Collection<CaptionSource> captionSources) {
        if (captionSources == null) {
            this.captionSources = null;
            return;
        }
        ListWithAutoConstructFlag captionSourcesCopy = new ListWithAutoConstructFlag(captionSources.size());
        captionSourcesCopy.addAll(captionSources);
        this.captionSources = captionSourcesCopy;
    }

    public Captions withCaptionSources(CaptionSource ... captionSources) {
        if (this.getCaptionSources() == null) {
            this.setCaptionSources(new ArrayList<CaptionSource>(captionSources.length));
        }
        for (CaptionSource value : captionSources) {
            this.getCaptionSources().add(value);
        }
        return this;
    }

    public Captions withCaptionSources(Collection<CaptionSource> captionSources) {
        if (captionSources == null) {
            this.captionSources = null;
        } else {
            ListWithAutoConstructFlag captionSourcesCopy = new ListWithAutoConstructFlag(captionSources.size());
            captionSourcesCopy.addAll(captionSources);
            this.captionSources = captionSourcesCopy;
        }
        return this;
    }

    public List<CaptionFormat> getCaptionFormats() {
        if (this.captionFormats == null) {
            this.captionFormats = new ListWithAutoConstructFlag();
            this.captionFormats.setAutoConstruct(true);
        }
        return this.captionFormats;
    }

    public void setCaptionFormats(Collection<CaptionFormat> captionFormats) {
        if (captionFormats == null) {
            this.captionFormats = null;
            return;
        }
        ListWithAutoConstructFlag captionFormatsCopy = new ListWithAutoConstructFlag(captionFormats.size());
        captionFormatsCopy.addAll(captionFormats);
        this.captionFormats = captionFormatsCopy;
    }

    public Captions withCaptionFormats(CaptionFormat ... captionFormats) {
        if (this.getCaptionFormats() == null) {
            this.setCaptionFormats(new ArrayList<CaptionFormat>(captionFormats.length));
        }
        for (CaptionFormat value : captionFormats) {
            this.getCaptionFormats().add(value);
        }
        return this;
    }

    public Captions withCaptionFormats(Collection<CaptionFormat> captionFormats) {
        if (captionFormats == null) {
            this.captionFormats = null;
        } else {
            ListWithAutoConstructFlag captionFormatsCopy = new ListWithAutoConstructFlag(captionFormats.size());
            captionFormatsCopy.addAll(captionFormats);
            this.captionFormats = captionFormatsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMergePolicy() != null) {
            sb.append("MergePolicy: " + this.getMergePolicy() + ",");
        }
        if (this.getCaptionSources() != null) {
            sb.append("CaptionSources: " + this.getCaptionSources() + ",");
        }
        if (this.getCaptionFormats() != null) {
            sb.append("CaptionFormats: " + this.getCaptionFormats());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMergePolicy() == null ? 0 : this.getMergePolicy().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionSources() == null ? 0 : this.getCaptionSources().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionFormats() == null ? 0 : this.getCaptionFormats().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Captions)) {
            return false;
        }
        Captions other = (Captions)obj;
        if (other.getMergePolicy() == null ^ this.getMergePolicy() == null) {
            return false;
        }
        if (other.getMergePolicy() != null && !other.getMergePolicy().equals(this.getMergePolicy())) {
            return false;
        }
        if (other.getCaptionSources() == null ^ this.getCaptionSources() == null) {
            return false;
        }
        if (other.getCaptionSources() != null && !other.getCaptionSources().equals(this.getCaptionSources())) {
            return false;
        }
        if (other.getCaptionFormats() == null ^ this.getCaptionFormats() == null) {
            return false;
        }
        return other.getCaptionFormats() == null || other.getCaptionFormats().equals(this.getCaptionFormats());
    }
}

