/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;

public class Innermost
extends SystemFunctionCall {
    boolean presorted = false;

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if ((this.argument[0].getSpecialProperties() & 0x80000) != 0) {
            return this.argument[0];
        }
        this.presorted = (this.argument[0].getSpecialProperties() & 0x20000) != 0;
        return this;
    }

    public Expression copy() {
        Innermost o = (Innermost)super.copy();
        o.presorted = this.presorted;
        return o;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.innermost(this.argument[0].iterate(context));
    }

    public int computeSpecialProperties() {
        return 655360;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.innermost(arguments[0].iterate()));
    }

    public SequenceIterator innermost(SequenceIterator in) throws XPathException {
        if (!this.presorted) {
            in = new DocumentOrderIterator(in, GlobalOrderComparer.getInstance());
        }
        return new InnermostIterator(in);
    }

    private class InnermostIterator
    implements SequenceIterator {
        SequenceIterator in;
        NodeInfo pending = null;
        int position = 0;

        public InnermostIterator(SequenceIterator in) throws XPathException {
            this.in = in;
            this.pending = (NodeInfo)in.next();
        }

        public NodeInfo next() throws XPathException {
            NodeInfo next;
            if (this.pending == null) {
                this.position = -1;
                return null;
            }
            while (true) {
                if ((next = (NodeInfo)this.in.next()) == null) {
                    NodeInfo current = this.pending;
                    ++this.position;
                    this.pending = null;
                    return current;
                }
                if (!Navigator.isAncestorOrSelf(this.pending, next)) break;
                this.pending = next;
            }
            ++this.position;
            NodeInfo current = this.pending;
            this.pending = next;
            return current;
        }

        public void close() {
            this.in.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new InnermostIterator(this.in.getAnother());
        }

        public int getProperties() {
            return 0;
        }
    }
}

