/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.server;

import java.net.InetSocketAddress;
import java.util.Date;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.service.profile.handlers.IamAdminServicesHandler;
import org.apache.airavata.service.profile.handlers.TenantProfileServiceHandler;
import org.apache.airavata.service.profile.handlers.UserProfileServiceHandler;
import org.apache.airavata.service.profile.iam.admin.services.cpi.IamAdminServices;
import org.apache.airavata.service.profile.tenant.cpi.TenantProfileService;
import org.apache.airavata.service.profile.user.cpi.UserProfileService;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileServiceServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(ProfileServiceServer.class);
    private static final String SERVER_NAME = "Profile Service Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;

    public ProfileServiceServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public void updateTime() {
    }

    public Date getTime() {
        return null;
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }

    public void start() throws Exception {
        try {
            TServerSocket serverTransport;
            this.setStatus(IServer.ServerStatus.STARTING);
            final int serverPort = Integer.parseInt(ServerSettings.getProfileServiceServerPort());
            String serverHost = ServerSettings.getProfileServiceServerHost();
            UserProfileService.Processor userProfileProcessor = new UserProfileService.Processor((UserProfileService.Iface)new UserProfileServiceHandler());
            TenantProfileService.Processor teneantProfileProcessor = new TenantProfileService.Processor((TenantProfileService.Iface)new TenantProfileServiceHandler());
            IamAdminServices.Processor iamAdminServicesProcessor = new IamAdminServices.Processor((IamAdminServices.Iface)new IamAdminServicesHandler());
            TMultiplexedProcessor profileServiceProcessor = new TMultiplexedProcessor();
            profileServiceProcessor.registerProcessor("UserProfileService", (TProcessor)userProfileProcessor);
            profileServiceProcessor.registerProcessor("TenantProfileService", (TProcessor)teneantProfileProcessor);
            profileServiceProcessor.registerProcessor("IamAdminServices", (TProcessor)iamAdminServicesProcessor);
            if (serverHost == null) {
                serverTransport = new TServerSocket(serverPort);
            } else {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
                serverTransport = new TServerSocket(inetSocketAddress);
            }
            TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)serverTransport);
            options.minWorkerThreads = 30;
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)options.processor((TProcessor)profileServiceProcessor));
            new Thread(){

                @Override
                public void run() {
                    ProfileServiceServer.this.server.serve();
                    ProfileServiceServer.this.setStatus(IServer.ServerStatus.STOPPED);
                    logger.info("Profile Service Server Stopped.");
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    while (!ProfileServiceServer.this.server.isServing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (ProfileServiceServer.this.server.isServing()) {
                        ProfileServiceServer.this.setStatus(IServer.ServerStatus.STARTED);
                        logger.info("Starting Profile Service Server on Port " + serverPort);
                        logger.info("Listening to Profile Service Server clients ....");
                    }
                }
            }.start();
        }
        catch (TTransportException e) {
            this.setStatus(IServer.ServerStatus.FAILED);
            throw new Exception("Error while starting the Profile Service Server", e);
        }
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public TServer getServer() {
        return this.server;
    }

    public void setServer(TServer server) {
        this.server = server;
    }

    public static void main(String[] args) {
        try {
            new ProfileServiceServer().start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

