/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.management.ConsoleCommandHandler;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class ConsoleCommandRequest
implements ConsoleRequest {
    private String command;

    public ConsoleCommandRequest() {
    }

    public ConsoleCommandRequest(String command) {
        this.command = command;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        ConsoleCommandHandler handler = mcs.getCommandHandler();
        try {
            String output = handler.handleCommand(this.command);
            IOUtil.writeLongString(dos, output);
        }
        catch (Throwable e) {
            IOUtil.writeLongString(dos, "Error: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
        }
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        return IOUtil.readLongString(in);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.command);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.command = in.readUTF();
    }
}

