/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Resources {
    public static final String CORE_POOL_SIZE = "wsrflite.resources.scheduled.size";
    public static final String POOL_TIMEOUT = "wsrflite.resources.scheduled.idletime";
    public static final String EXEC_CORE_POOL_SIZE = "wsrflite.resources.executor.minsize";
    public static final String EXEC_MAX_POOL_SIZE = "wsrflite.resources.executor.maxsize";
    public static final String EXEC_POOL_TIMEOUT = "wsrflite.resources.executor.idletime";
    private static boolean isConfigured = false;
    private static ScheduledThreadPoolExecutor scheduler;
    private static ThreadPoolExecutor executor;

    private Resources() {
    }

    public static synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (!isConfigured) {
            Resources.configure();
        }
        return scheduler;
    }

    public static synchronized ExecutorService getExecutorService() {
        if (!isConfigured) {
            Resources.configure();
        }
        return executor;
    }

    public static synchronized <V> CompletionService<V> getCompletionService() {
        return new ExecutorCompletionService(Resources.getExecutorService());
    }

    protected static void configure() {
        Resources.configureScheduler();
        Resources.configureExecutor();
        isConfigured = true;
    }

    protected static void configureScheduler() {
        int core = 2;
        scheduler = new ScheduledThreadPoolExecutor(core);
        int idle = 50;
        scheduler.setKeepAliveTime(idle, TimeUnit.MILLISECONDS);
        scheduler.setThreadFactory(new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("client-sched-" + this.threadNumber.getAndIncrement());
                return t;
            }
        });
    }

    protected static void configureExecutor() {
        int min = 2;
        int max = 32;
        int idle = 50;
        executor = new ThreadPoolExecutor(min, max, (long)idle, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("wsrflite-executor-" + this.threadNumber.getAndIncrement());
                return t;
            }
        });
    }

    public static int getScheduledExecutorCorePoolSize() {
        return scheduler.getCorePoolSize();
    }

    public static int getScheduledExecutorMaxPoolSize() {
        return scheduler.getMaximumPoolSize();
    }

    public static int getScheduledExecutorActiveThreadCount() {
        return scheduler.getActiveCount();
    }

    public static int getExecutorCorePoolSize() {
        return executor.getCorePoolSize();
    }

    public static int getExecutorMaxPoolSize() {
        return executor.getMaximumPoolSize();
    }

    public static int getExecutorActiveThreadCount() {
        return executor.getActiveCount();
    }
}

