/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLBindings;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.exceptions.SAMLValidationSoftException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.AssertionValidator;
import eu.unicore.samly2.validators.ReplayAttackChecker;
import java.util.Calendar;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;

public class SSOAuthnAssertionValidator
extends AssertionValidator {
    protected ReplayAttackChecker replayChecker;
    protected SAMLBindings binding;
    protected boolean laxInResponseToChecking = false;

    public SSOAuthnAssertionValidator(String consumerSamlName, String consumerEndpointUri, String requestId, long samlValidityGraceTime, SamlTrustChecker trustChecker, ReplayAttackChecker replayChecker, SAMLBindings binding) {
        super(consumerSamlName, consumerEndpointUri, requestId, samlValidityGraceTime, trustChecker);
        this.replayChecker = replayChecker;
        this.binding = binding;
    }

    public void setLaxInResponseToChecking(boolean beLax) {
        this.laxInResponseToChecking = beLax;
    }

    @Override
    public void validate(AssertionDocument assertionDoc) throws SAMLValidationException {
        super.validate(assertionDoc);
        AssertionType assertionXml = assertionDoc.getAssertion();
        this.checkStatements(assertionXml);
        NameIDType issuer = assertionXml.getIssuer();
        if (issuer.getFormat() != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(issuer.getFormat())) {
            throw new SAMLValidationException("SAML SSO authentication profile requires issuer to be of entity type. Was: " + issuer.getFormat());
        }
        if (assertionXml.getAuthnStatementArray() == null || assertionXml.getAuthnStatementArray().length == 0) {
            throw new SAMLValidationException("Not an authentication assertion - no authN satements");
        }
        Calendar notAfter = this.checkAuthNSubject(assertionXml.getSubject());
        if (assertionXml.getConditions() == null || assertionXml.getConditions().getAudienceRestrictionArray() == null || assertionXml.getConditions().getAudienceRestrictionArray().length == 0) {
            throw new SAMLValidationSoftException("SAML SSO authentication profile requires that audience restriction must be set and it wasn't.");
        }
        if (this.binding == SAMLBindings.HTTP_POST) {
            this.replayChecker.checkAndStore(assertionXml.getID(), notAfter);
            if (assertionXml.getSignature() == null || assertionXml.getSignature().isNil()) {
                throw new SAMLValidationException("Assertion is not signed in the SSO authN used over HTTP POST, while should be.");
            }
        }
    }

    protected Calendar checkAuthNSubject(SubjectType subject) throws SAMLValidationSoftException {
        SubjectConfirmationType[] confirmations = subject.getSubjectConfirmationArray();
        if (confirmations == null || confirmations.length == 0) {
            throw new SAMLValidationSoftException("Authentication assertion subject confirmation is not set");
        }
        for (SubjectConfirmationType confirmation : confirmations) {
            SubjectConfirmationDataType confData = confirmation.getSubjectConfirmationData();
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod())) continue;
            if (confData == null || confData.isNil()) {
                throw new SAMLValidationSoftException("In authentication assertion the bearer subject confirmation must have confirmation data set");
            }
            if (confData.getRecipient() == null) {
                throw new SAMLValidationSoftException("Authentication assertion confirmation receipent URL must be set");
            }
            if (confData.getNotOnOrAfter() == null) {
                throw new SAMLValidationSoftException("Bearer subject confirmation must have notOnOrAfter defined");
            }
            if (confData.getNotBefore() != null) {
                throw new SAMLValidationSoftException("Bearer subject confirmation must not have notBefore defined");
            }
            if (this.requestId == null && confData.isSetInResponseTo() && !this.laxInResponseToChecking) {
                throw new SAMLValidationSoftException("InResponseTo present, while it was expected to have an unsolicited response");
            }
            return confData.getNotOnOrAfter();
        }
        throw new SAMLValidationSoftException("Authentication assertion subject doesn't posses any bearer type subject confirmation");
    }
}

