/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.HttpClientProperties;
import eu.unicore.util.httpclient.ServerHostnameCheckingMode;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientProperties
extends DefaultClientConfiguration {
    private static final Logger log = Log.getLogger("unicore.configuration", ClientProperties.class);
    public static final String DEFAULT_PREFIX = "client.";
    public static final String PROP_HTTP_AUTHN_ENABLED = "httpAuthnEnabled";
    public static final String PROP_HTTP_USER = "httpUser";
    public static final String PROP_HTTP_PASSWORD = "httpPassword";
    public static final String PROP_SSL_ENABLED = "sslEnabled";
    public static final String PROP_SSL_AUTHN_ENABLED = "sslAuthnEnabled";
    public static final String PROP_MESSAGE_SIGNING_ENABLED = "digitalSigningEnabled";
    public static final String PROP_IN_HANDLERS = "inHandlers";
    public static final String PROP_OUT_HANDLERS = "outHandlers";
    public static final String PROP_SERVER_HOSTNAME_CHECKING = "serverHostnameChecking";
    public static final String PROP_MESSAGE_LOGGING = "messageLogging";
    public static final String PROP_SECURITY_SESSIONS = "securitySessions";
    public static final String PROP_MAX_RETRIES = "maxWsCallRetries";
    public static final String PROP_RETRY_DELAY = "wsCallRetryDelay";
    private IAuthnAndTrustConfiguration authnAndTrustConfiguration;
    private PropertiesHelper clientPropertiesHelper;
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public ClientProperties(String file) throws IOException, ConfigurationException {
        this(new File(file));
    }

    public ClientProperties(File file) throws IOException, ConfigurationException {
        this(FilePropertiesHelper.load(file));
    }

    public ClientProperties(String file, String trustPrefix, String credPrefix) throws IOException, ConfigurationException {
        this(new File(file), trustPrefix, credPrefix);
    }

    public ClientProperties(File file, String trustPrefix, String credPrefix) throws IOException, ConfigurationException {
        this(FilePropertiesHelper.load(file), trustPrefix, credPrefix, DEFAULT_PREFIX);
    }

    public ClientProperties(Properties p) throws ConfigurationException {
        this(p, "truststore.", "credential.", DEFAULT_PREFIX);
    }

    public ClientProperties(Properties p, String trustPrefix, String credPrefix, String clientPrefix) throws ConfigurationException {
        this(p, clientPrefix, ClientProperties.getDefaultAuthnAndTrust(p, null, trustPrefix, credPrefix, clientPrefix));
    }

    public ClientProperties(Properties p, PasswordCallback callback, String trustPrefix, String credPrefix, String clientPrefix) throws ConfigurationException {
        this(p, clientPrefix, ClientProperties.getDefaultAuthnAndTrust(p, callback, trustPrefix, credPrefix, clientPrefix));
    }

    public ClientProperties(Properties p, IAuthnAndTrustConfiguration authAndTrust) throws ConfigurationException {
        this(p, DEFAULT_PREFIX, authAndTrust);
    }

    public static AuthnAndTrustProperties getDefaultAuthnAndTrust(Properties p, PasswordCallback callback, String trustPrefix, String credPrefix, String clientPrefix) {
        boolean signOff;
        boolean trustOptional = false;
        boolean credOptional = false;
        String sslP = p.getProperty(clientPrefix + PROP_SSL_ENABLED);
        String sslAuthnP = p.getProperty(clientPrefix + PROP_SSL_AUTHN_ENABLED);
        String signP = p.getProperty(clientPrefix + PROP_MESSAGE_SIGNING_ENABLED);
        boolean sslOff = sslP != null && (sslP.equalsIgnoreCase("false") || sslP.equalsIgnoreCase("no"));
        boolean sslAuthnOff = sslAuthnP != null && (sslAuthnP.equalsIgnoreCase("false") || sslAuthnP.equalsIgnoreCase("no"));
        boolean bl = signOff = signP != null && (signP.equalsIgnoreCase("false") || signP.equalsIgnoreCase("no"));
        if (sslOff) {
            trustOptional = true;
            if (signOff) {
                credOptional = true;
            }
        } else if (sslAuthnOff && signOff) {
            credOptional = true;
        }
        return new AuthnAndTrustProperties(p, trustPrefix, credPrefix, callback, trustOptional, credOptional);
    }

    protected ClientProperties() {
    }

    public ClientProperties(Properties p, String clientPrefix, IAuthnAndTrustConfiguration authAndTrust) throws ConfigurationException {
        this.setValidator(authAndTrust.getValidator());
        this.setCredential(authAndTrust.getCredential());
        this.authnAndTrustConfiguration = authAndTrust;
        this.clientPropertiesHelper = new PropertiesHelper(clientPrefix, p, META, log);
        this.setSslEnabled(this.clientPropertiesHelper.getBooleanValue(PROP_SSL_ENABLED));
        if (this.isSslEnabled()) {
            if (this.getValidator() == null) {
                throw new ConfigurationException("When SSL mode is enabled trust settings must be provided");
            }
            this.setSslAuthn(this.clientPropertiesHelper.getBooleanValue(PROP_SSL_AUTHN_ENABLED));
            if (this.doSSLAuthn() && this.getCredential() == null) {
                throw new ConfigurationException("When SSL authentication is enabled the credential must be provided");
            }
            if (this.getCredential() != null) {
                this.getETDSettings().setIssuerCertificateChain(this.getCredential().getCertificateChain());
            }
        }
        this.setDoSignMessage(this.clientPropertiesHelper.getBooleanValue(PROP_MESSAGE_SIGNING_ENABLED));
        if (this.doSignMessage() && this.getCredential() == null) {
            throw new ConfigurationException("When message signing is enabled, the credential must be provided");
        }
        this.setHttpAuthn(this.clientPropertiesHelper.getBooleanValue(PROP_HTTP_AUTHN_ENABLED));
        if (this.doHttpAuthn()) {
            this.setHttpPassword(this.clientPropertiesHelper.getValue(PROP_HTTP_PASSWORD));
            this.setHttpUser(this.clientPropertiesHelper.getValue(PROP_HTTP_USER));
        }
        this.setInHandlerClassNames(this.parseHandlers(this.clientPropertiesHelper, PROP_IN_HANDLERS));
        this.setOutHandlerClassNames(this.parseHandlers(this.clientPropertiesHelper, PROP_OUT_HANDLERS));
        ServerHostnameCheckingMode hostnameMode = this.clientPropertiesHelper.getEnumValue(PROP_SERVER_HOSTNAME_CHECKING, ServerHostnameCheckingMode.class);
        this.setServerHostnameCheckingMode(hostnameMode);
        HttpClientProperties httpProperties = new HttpClientProperties(clientPrefix + "http.", p);
        this.setHttpClientProperties(httpProperties);
        this.setMessageLogging(this.clientPropertiesHelper.getBooleanValue(PROP_MESSAGE_LOGGING));
        this.setUseSecuritySessions(this.clientPropertiesHelper.getBooleanValue(PROP_SECURITY_SESSIONS));
        this.setMaxWSRetries(this.clientPropertiesHelper.getIntValue(PROP_MAX_RETRIES));
        this.setRetryDelay(this.clientPropertiesHelper.getLongValue(PROP_RETRY_DELAY));
    }

    private String[] parseHandlers(PropertiesHelper properties, String key) {
        String handlers = properties.getValue(key);
        if (handlers != null) {
            handlers.trim();
        }
        if (handlers != null) {
            return handlers.split("[ ]+");
        }
        return new String[0];
    }

    @Override
    public ClientProperties clone() {
        ClientProperties ret = (ClientProperties)super.clone();
        ret.authnAndTrustConfiguration = this.authnAndTrustConfiguration;
        ret.clientPropertiesHelper = this.clientPropertiesHelper.clone();
        return ret;
    }

    @Deprecated
    public ClientProperties shallowClone() {
        return this.clone();
    }

    public IAuthnAndTrustConfiguration getAuthnAndTrustConfiguration() {
        return this.authnAndTrustConfiguration;
    }

    public PropertiesHelper getClientPropertiesHelper() {
        return this.clientPropertiesHelper;
    }

    static {
        META.put(PROP_HTTP_AUTHN_ENABLED, new PropertyMD("false").setDescription("Whether HTTP basic authentication should be used."));
        META.put(PROP_HTTP_PASSWORD, new PropertyMD("").setSecret().setDescription("Password for use with HTTP basic authentication (if enabled)."));
        META.put(PROP_HTTP_USER, new PropertyMD("").setDescription("Username for use with HTTP basic authentication (if enabled)."));
        META.put(PROP_IN_HANDLERS, new PropertyMD("").setDescription("Space separated list of additional handler class names for handling incoming WS messages"));
        META.put(PROP_MESSAGE_SIGNING_ENABLED, new PropertyMD("true").setDescription("Controls whether signing of key web service requests should be performed."));
        META.put(PROP_OUT_HANDLERS, new PropertyMD("").setDescription("Space separated list of additional handler class names for handling outgoing WS messages"));
        META.put(PROP_SSL_AUTHN_ENABLED, new PropertyMD("true").setDescription("Controls whether SSL authentication of the client should be performed."));
        META.put(PROP_SSL_ENABLED, new PropertyMD("true").setDescription("Controls whether the SSL/TLS connection mode is enabled."));
        META.put(PROP_SERVER_HOSTNAME_CHECKING, new PropertyMD(ServerHostnameCheckingMode.WARN).setDescription("Controls whether server's hostname should be checked for matching its certificate subject. This verification prevents man-in-the-middle attacks. If enabled WARN will only print warning in log, FAIL will close the connection."));
        META.put(PROP_MESSAGE_LOGGING, new PropertyMD("false").setDescription("Controls whether messages should be logged (at INFO level)."));
        META.put(PROP_SECURITY_SESSIONS, new PropertyMD("true").setDescription("Controls whether security sessions should be enabled."));
        META.put(PROP_MAX_RETRIES, new PropertyMD("3").setDescription("Controls how many times the client should try to call a failing web service. Note that only the transient failure reasons cause the retry. Note that value of 0 enables unlimited number of retries, while value of 1 means that only one call is tried."));
        META.put(PROP_RETRY_DELAY, new PropertyMD("10000").setDescription("Amount of milliseconds to wait before retry of a failed web service call."));
        for (Map.Entry<String, PropertyMD> entry : HttpClientProperties.META.entrySet()) {
            META.put("http." + entry.getKey(), entry.getValue());
        }
    }
}

