/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeImagesResult
implements Serializable {
    private ListWithAutoConstructFlag<Image> images;

    public List<Image> getImages() {
        if (this.images == null) {
            this.images = new ListWithAutoConstructFlag();
            this.images.setAutoConstruct(true);
        }
        return this.images;
    }

    public void setImages(Collection<Image> images) {
        if (images == null) {
            this.images = null;
            return;
        }
        ListWithAutoConstructFlag imagesCopy = new ListWithAutoConstructFlag(images.size());
        imagesCopy.addAll(images);
        this.images = imagesCopy;
    }

    public DescribeImagesResult withImages(Image ... images) {
        if (this.getImages() == null) {
            this.setImages(new ArrayList<Image>(images.length));
        }
        for (Image value : images) {
            this.getImages().add(value);
        }
        return this;
    }

    public DescribeImagesResult withImages(Collection<Image> images) {
        if (images == null) {
            this.images = null;
        } else {
            ListWithAutoConstructFlag imagesCopy = new ListWithAutoConstructFlag(images.size());
            imagesCopy.addAll(images);
            this.images = imagesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImages() != null) {
            sb.append("Images: " + this.getImages());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImages() == null ? 0 : this.getImages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResult)) {
            return false;
        }
        DescribeImagesResult other = (DescribeImagesResult)obj;
        if (other.getImages() == null ^ this.getImages() == null) {
            return false;
        }
        return other.getImages() == null || other.getImages().equals(this.getImages());
    }
}

