/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsMetadata {
    private static final Logger log = LoggerFactory.getLogger(AwsMetadata.class);
    private static final String METADATA_URI_BASE = "http://169.254.169.254/";
    private static final String REGION_SUFFIX = "/latest/dynamic/instance-identity/document";
    private static final String ZONE_SUFFIX = "/latest/meta-data/placement/availability-zone";
    private static final String PUBLIC_IPV4_SUFFIX = "/latest/meta-data/public-ipv4";
    private static final String PRIVATE_IPV4_SUFFIX = "latest/meta-data/local-ipv4";
    private static final String HOSTNAME_SUFFIX = "/latest/meta-data/hostname";
    private static final String ID_SUFFIX = "/latest/meta-data/instance-id";
    private final URI baseUri;
    private String id;
    private String region;
    private String hostname;
    private String zone;
    private InetAddress publicIp;
    private InetAddress privateIp;

    public AwsMetadata() {
        try {
            this.baseUri = new URI(METADATA_URI_BASE);
        }
        catch (URISyntaxException e) {
            Preconditions.checkState((boolean)false, (String)"Unexpected URI Syntax Exception: {}", (Object)e);
            throw new RuntimeException(e);
        }
    }

    public String getRegion() {
        if (this.region == null) {
            try {
                String dynamicData = this.getMetadataAt(REGION_SUFFIX);
                if (dynamicData != null) {
                    JsonObject asJsonObject = new JsonParser().parse(dynamicData).getAsJsonObject();
                    this.region = asJsonObject.get("region").getAsString();
                }
            }
            catch (ClassCastException e) {
                log.error("Unable to get region, expecting a JSON Object", (Throwable)e);
            }
        }
        return this.region;
    }

    public String getZoneName() {
        if (this.zone == null) {
            this.zone = this.getMetadataAt(ZONE_SUFFIX);
        }
        return this.zone;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getMetadataAt(ID_SUFFIX);
        }
        return this.id;
    }

    public String getHostname() {
        if (this.hostname == null) {
            this.hostname = this.getMetadataAt(HOSTNAME_SUFFIX);
        }
        return this.hostname;
    }

    public InetAddress getPublicIpAddress() {
        String ip;
        if (this.publicIp == null && (ip = this.getMetadataAt(PUBLIC_IPV4_SUFFIX)) != null) {
            this.publicIp = InetAddresses.forString((String)ip);
        }
        return this.publicIp;
    }

    public InetAddress getInternalIpAddress() {
        String ip;
        if (this.privateIp == null && (ip = this.getMetadataAt(PRIVATE_IPV4_SUFFIX)) != null) {
            this.privateIp = InetAddresses.forString((String)ip);
        }
        return this.privateIp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMetadataAt(String suffix) {
        try {
            URI resolved = this.baseUri.resolve(suffix);
            StringBuilder builder = new StringBuilder();
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resolved.toURL().openStream()));){
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                String string = builder.toString();
                return string;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

