/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeApplicationVersionsRequestMarshaller
implements Marshaller<Request<DescribeApplicationVersionsRequest>, DescribeApplicationVersionsRequest> {
    public Request<DescribeApplicationVersionsRequest> marshall(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        if (describeApplicationVersionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationVersionsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeApplicationVersions");
        request.addParameter("Version", "2010-12-01");
        if (describeApplicationVersionsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeApplicationVersionsRequest.getApplicationName()));
        }
        List<String> versionLabelsList = describeApplicationVersionsRequest.getVersionLabels();
        int versionLabelsListIndex = 1;
        for (String versionLabelsListValue : versionLabelsList) {
            if (versionLabelsListValue != null) {
                request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringUtils.fromString((String)versionLabelsListValue));
            }
            ++versionLabelsListIndex;
        }
        return request;
    }
}

