/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.validator;

import org.apache.axis2.jaxws.description.validator.ValidationFailure;
import org.apache.axis2.jaxws.description.validator.ValidationFailures;

public abstract class Validator {
    public static final boolean VALID = true;
    public static final boolean INVALID = false;
    protected ValidationFailures validationFailures = new ValidationFailures();
    private ValidationLevel validationLevel = ValidationLevel.FULL;

    public abstract boolean validate();

    protected boolean validate(boolean performVaidation) {
        return true;
    }

    void addValidationFailure(Validator failingValidator, String message) {
        this.validationFailures.add(failingValidator, message);
    }

    ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public String toString() {
        String messageString = "";
        for (ValidationFailure failure : this.validationFailures.getValidationFailures()) {
            messageString = messageString + " :: " + failure.getMessage();
            Validator validator = failure.getValidator();
            if (validator == this) continue;
            messageString = messageString + " :: " + validator.toString();
        }
        return messageString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationLevel {
        OFF,
        FULL;

    }
}

