/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import jakarta.persistence.FetchType;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.hibernate.annotations.FetchMode;
import org.hibernate.mapping.MetadataSource;

public class FetchProfile {
    private final String name;
    private final MetadataSource source;
    private final LinkedHashSet<Fetch> fetches = new LinkedHashSet();

    public FetchProfile(String name, MetadataSource source) {
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public MetadataSource getSource() {
        return this.source;
    }

    public LinkedHashSet<Fetch> getFetches() {
        return this.fetches;
    }

    @Deprecated(forRemoval=true)
    public void addFetch(String entity, String association, String style) {
        this.addFetch(new Fetch(entity, association, style));
    }

    public void addFetch(Fetch fetch) {
        this.fetches.add(fetch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchProfile that = (FetchProfile)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Fetch {
        private final String entity;
        private final String association;
        private final FetchMode method;
        private final FetchType type;

        public Fetch(String entity, String association, FetchMode method, FetchType type) {
            this.entity = entity;
            this.association = association;
            this.method = method;
            this.type = type;
        }

        @Deprecated(forRemoval=true)
        public Fetch(String entity, String association, String style) {
            this.entity = entity;
            this.association = association;
            this.method = this.fetchMode(style);
            this.type = FetchType.EAGER;
        }

        private FetchMode fetchMode(String style) {
            for (FetchMode mode : FetchMode.values()) {
                if (!mode.name().equalsIgnoreCase(style)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown FetchMode: " + style);
        }

        public String getEntity() {
            return this.entity;
        }

        public String getAssociation() {
            return this.association;
        }

        @Deprecated(forRemoval=true)
        public String getStyle() {
            return this.method.toString().toLowerCase(Locale.ROOT);
        }

        public FetchMode getMethod() {
            return this.method;
        }

        public FetchType getType() {
            return this.type;
        }
    }
}

