/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.common.LocalResource;

public class DatasetResource
implements Comparable<DatasetResource> {
    private final DatasetInfo datasetInfo;
    private final Map<Integer, PrimaryIndexOperationTracker> datasetPrimaryOpTrackers;
    private final Map<Integer, ILSMComponentIdGenerator> datasetComponentIdGenerators;

    public DatasetResource(DatasetInfo datasetInfo) {
        this.datasetInfo = datasetInfo;
        this.datasetPrimaryOpTrackers = new HashMap<Integer, PrimaryIndexOperationTracker>();
        this.datasetComponentIdGenerators = new HashMap<Integer, ILSMComponentIdGenerator>();
    }

    public boolean isRegistered() {
        return this.datasetInfo.isRegistered();
    }

    public IndexInfo getIndexInfo(long resourceID) {
        return this.datasetInfo.getIndexes().get(resourceID);
    }

    public boolean isOpen() {
        return this.datasetInfo.isOpen();
    }

    public boolean isExternal() {
        return this.datasetInfo.isExternal();
    }

    public void open(boolean open) {
        this.datasetInfo.setOpen(open);
    }

    public void touch() {
        this.datasetInfo.touch();
    }

    public void untouch() {
        this.datasetInfo.untouch();
    }

    public ILSMIndex getIndex(long resourceID) {
        IndexInfo iInfo = this.getIndexInfo(resourceID);
        return iInfo == null ? null : iInfo.getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(LocalResource resource, ILSMIndex index) throws HyracksDataException {
        long resourceID = resource.getId();
        if (!this.datasetInfo.isRegistered()) {
            DatasetInfo datasetInfo = this.datasetInfo;
            synchronized (datasetInfo) {
                if (!this.datasetInfo.isRegistered()) {
                    this.datasetInfo.setExternal(index.getNumberOfAllMemoryComponents() == 0);
                    this.datasetInfo.setRegistered(true);
                    this.datasetInfo.setDurable(index.isDurable());
                }
            }
        }
        if (this.datasetInfo.getIndexes().containsKey(resourceID)) {
            throw new HyracksDataException("Index with resource ID " + resourceID + " already exists.");
        }
        if (index == null) {
            throw new HyracksDataException("Attempt to register a null index");
        }
        this.datasetInfo.addIndex(resourceID, new IndexInfo(index, this.datasetInfo.getDatasetID(), resource, ((DatasetLocalResource)resource.getResource()).getPartition()));
    }

    public DatasetInfo getDatasetInfo() {
        return this.datasetInfo;
    }

    public PrimaryIndexOperationTracker getOpTracker(int partition) {
        return this.datasetPrimaryOpTrackers.get(partition);
    }

    public Collection<PrimaryIndexOperationTracker> getOpTrackers() {
        return this.datasetPrimaryOpTrackers.values();
    }

    public ILSMComponentIdGenerator getComponentIdGenerator(int partition) {
        return this.datasetComponentIdGenerators.get(partition);
    }

    public void setPrimaryIndexOperationTracker(int partition, PrimaryIndexOperationTracker opTracker) {
        if (this.datasetPrimaryOpTrackers.containsKey(partition)) {
            throw new IllegalStateException("PrimaryIndexOperationTracker has already been set for partition " + partition);
        }
        this.datasetPrimaryOpTrackers.put(partition, opTracker);
    }

    public void setIdGenerator(int partition, ILSMComponentIdGenerator idGenerator) {
        if (this.datasetComponentIdGenerators.containsKey(partition)) {
            throw new IllegalStateException("LSMComponentIdGenerator has already been set for partition " + partition);
        }
        this.datasetComponentIdGenerators.put(partition, idGenerator);
    }

    @Override
    public int compareTo(DatasetResource o) {
        return this.datasetInfo.compareTo(o.datasetInfo);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatasetResource) {
            return this.datasetInfo.equals(((DatasetResource)obj).datasetInfo);
        }
        return false;
    }

    public int hashCode() {
        return this.datasetInfo.hashCode();
    }

    public Map<Long, IndexInfo> getIndexes() {
        return this.datasetInfo.getIndexes();
    }

    public int getDatasetID() {
        return this.datasetInfo.getDatasetID();
    }

    public boolean isMetadataDataset() {
        return MetadataIndexImmutableProperties.isMetadataDataset(this.getDatasetID());
    }
}

