/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class LibraryDescriptor
implements IJsonSerializable {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_LANGUAGE = "lang";
    public static final String FILE_EXT_ZIP = "zip";
    public static final String FILE_EXT_PYZ = "pyz";
    private final ExternalFunctionLanguage lang;

    public LibraryDescriptor(ExternalFunctionLanguage language) {
        this.lang = language;
    }

    public ExternalFunctionLanguage getLanguage() {
        return this.lang;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) {
        ObjectNode jsonNode = registry.getClassIdentifier(LibraryDescriptor.class, 1L);
        jsonNode.put(FIELD_LANGUAGE, this.lang.name());
        return jsonNode;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        String langText = json.get(FIELD_LANGUAGE).asText();
        ExternalFunctionLanguage lang = ExternalFunctionLanguage.valueOf(langText);
        return new LibraryDescriptor(lang);
    }
}

