/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort.util;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.sort.util.IAppendDeletableFrameTupleAccessor;
import org.apache.hyracks.util.IntSerDeUtils;

public class DeletableFrameTupleAppender
implements IAppendDeletableFrameTupleAccessor {
    private static final int SIZE_DELETED_SPACE = 4;
    private final RecordDescriptor recordDescriptor;
    private ByteBuffer buffer;
    private int tupleCountOffset;
    private int tupleCount;
    private int freeDataEndOffset;
    private int deletedSpace;
    private byte[] array;

    public DeletableFrameTupleAppender(RecordDescriptor recordDescriptor) {
        this.recordDescriptor = recordDescriptor;
    }

    private int getTupleCountOffset() {
        return FrameHelper.getTupleCountOffset((int)this.buffer.capacity()) - 4;
    }

    private int getFreeDataEndOffset() {
        return this.tupleCount == 0 ? 0 : Math.abs(IntSerDeUtils.getInt((byte[])this.array, (int)(this.tupleCountOffset - this.tupleCount * 4)));
    }

    private void setFreeDataEndOffset(int offset) {
        assert (offset >= 0);
        IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleCountOffset - this.tupleCount * 4), (int)offset);
    }

    private void setTupleCount(int count) {
        IntSerDeUtils.putInt((byte[])this.array, (int)this.tupleCountOffset, (int)count);
    }

    private void setDeleteSpace(int count) {
        IntSerDeUtils.putInt((byte[])this.array, (int)(this.buffer.capacity() - 4), (int)count);
    }

    private int getPhysicalTupleCount() {
        return IntSerDeUtils.getInt((byte[])this.array, (int)this.tupleCountOffset);
    }

    private int getDeletedSpace() {
        return IntSerDeUtils.getInt((byte[])this.array, (int)(this.buffer.capacity() - 4));
    }

    @Override
    public void clear(ByteBuffer buffer) throws HyracksDataException {
        this.buffer = buffer;
        this.array = buffer.array();
        this.tupleCountOffset = this.getTupleCountOffset();
        this.setTupleCount(0);
        this.setDeleteSpace(0);
        this.resetCounts();
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
        this.array = buffer.array();
        this.tupleCountOffset = this.getTupleCountOffset();
        this.resetCounts();
    }

    private void resetCounts() {
        this.deletedSpace = this.getDeletedSpace();
        this.tupleCount = this.getPhysicalTupleCount();
        this.freeDataEndOffset = this.getFreeDataEndOffset();
    }

    @Override
    public int append(IFrameTupleAccessor tupleAccessor, int tIndex) throws HyracksDataException {
        byte[] src = tupleAccessor.getBuffer().array();
        int tStartOffset = tupleAccessor.getTupleStartOffset(tIndex);
        int length = tupleAccessor.getTupleLength(tIndex);
        System.arraycopy(src, tStartOffset, this.array, this.freeDataEndOffset, length);
        this.setTupleCount(++this.tupleCount);
        this.freeDataEndOffset += length;
        this.setFreeDataEndOffset(this.freeDataEndOffset);
        return this.tupleCount - 1;
    }

    @Override
    public void delete(int tupleIndex) {
        int endOffset = this.getTupleEndOffset(tupleIndex);
        if (endOffset > 0) {
            this.setTupleEndOffset(tupleIndex, -endOffset);
            this.deletedSpace += endOffset - this.getTupleStartOffset(tupleIndex);
            this.setDeleteSpace(this.deletedSpace);
        }
    }

    @Override
    public void reOrganizeBuffer() {
        if (this.deletedSpace <= 0) {
            return;
        }
        this.reclaimDeletedEnding();
        this.freeDataEndOffset = 0;
        int endOffset = 0;
        for (int i = 0; i < this.tupleCount; ++i) {
            int startOffset = Math.abs(endOffset);
            endOffset = this.getTupleEndOffset(i);
            if (endOffset >= 0) {
                int length = endOffset - startOffset;
                assert (length >= 0);
                if (this.freeDataEndOffset != startOffset) {
                    System.arraycopy(this.array, startOffset, this.array, this.freeDataEndOffset, length);
                }
                this.freeDataEndOffset += length;
            }
            this.setTupleEndOffset(i, this.freeDataEndOffset);
        }
        this.setFreeDataEndOffset(this.freeDataEndOffset);
        this.deletedSpace = 0;
        this.setDeleteSpace(0);
    }

    private void reclaimDeletedEnding() {
        int endOffset;
        for (int i = this.tupleCount - 1; i >= 0 && (endOffset = this.getTupleEndOffset(i)) < 0; --i) {
            --this.tupleCount;
        }
        this.setTupleCount(this.tupleCount);
    }

    @Override
    public int getTotalFreeSpace() {
        return this.getContiguousFreeSpace() + this.deletedSpace;
    }

    @Override
    public int getContiguousFreeSpace() {
        return this.getTupleCountOffset() - this.tupleCount * 4 - this.freeDataEndOffset;
    }

    public int getFieldCount() {
        return this.recordDescriptor.getFieldCount();
    }

    public int getFieldSlotsLength() {
        return this.recordDescriptor.getFieldCount() * 4;
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return IntSerDeUtils.getInt((byte[])this.array, (int)(this.getTupleStartOffset(tupleIndex) + fIdx * 4));
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])this.array, (int)(this.getTupleStartOffset(tupleIndex) + (fIdx - 1) * 4));
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.getFieldEndOffset(tupleIndex, fIdx) - this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleLength(int tupleIndex) {
        int endOffset = this.getTupleEndOffset(tupleIndex);
        if (endOffset < 0) {
            return endOffset + this.getTupleStartOffset(tupleIndex);
        }
        return endOffset - this.getTupleStartOffset(tupleIndex);
    }

    public int getTupleEndOffset(int tupleIndex) {
        return IntSerDeUtils.getInt((byte[])this.array, (int)(this.tupleCountOffset - 4 * (tupleIndex + 1)));
    }

    private void setTupleEndOffset(int tupleIndex, int offset) {
        IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleCountOffset - 4 * (tupleIndex + 1)), (int)offset);
    }

    public int getTupleStartOffset(int tupleIndex) {
        int offset = tupleIndex == 0 ? 0 : IntSerDeUtils.getInt((byte[])this.array, (int)(this.tupleCountOffset - 4 * tupleIndex));
        return Math.abs(offset);
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleCount() {
        return this.tupleCount;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

