/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class TokenizeOperator
extends AbstractLogicalOperator {
    private final IDataSourceIndex<?, ?> dataSourceIndex;
    private final List<Mutable<ILogicalExpression>> primaryKeyExprs;
    private final List<Mutable<ILogicalExpression>> secondaryKeyExprs;
    private final List<LogicalVariable> tokenizeVars;
    private final Mutable<ILogicalExpression> filterExpr;
    private final InsertDeleteUpsertOperator.Kind operation;
    private final boolean bulkload;
    private final boolean isPartitioned;
    private final List<Object> tokenizeVarTypes;
    private List<Mutable<ILogicalExpression>> additionalFilteringExpressions;

    public TokenizeOperator(IDataSourceIndex<?, ?> dataSourceIndex, List<Mutable<ILogicalExpression>> primaryKeyExprs, List<Mutable<ILogicalExpression>> secondaryKeyExprs, List<LogicalVariable> tokenizeVars, Mutable<ILogicalExpression> filterExpr, InsertDeleteUpsertOperator.Kind operation, boolean bulkload, boolean isPartitioned, List<Object> tokenizeVarTypes) {
        this.dataSourceIndex = dataSourceIndex;
        this.primaryKeyExprs = primaryKeyExprs;
        this.secondaryKeyExprs = secondaryKeyExprs;
        this.tokenizeVars = tokenizeVars;
        this.filterExpr = filterExpr;
        this.operation = operation;
        this.bulkload = bulkload;
        this.isPartitioned = isPartitioned;
        this.tokenizeVarTypes = tokenizeVarTypes;
    }

    @Override
    public void recomputeSchema() throws AlgebricksException {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
        this.schema.addAll(this.tokenizeVars);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        int i;
        boolean b = false;
        for (i = 0; i < this.primaryKeyExprs.size(); ++i) {
            if (!visitor.transform(this.primaryKeyExprs.get(i))) continue;
            b = true;
        }
        for (i = 0; i < this.secondaryKeyExprs.size(); ++i) {
            if (!visitor.transform(this.secondaryKeyExprs.get(i))) continue;
            b = true;
        }
        return b;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitTokenizeOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                target.addAllVariables(sources[0]);
                for (LogicalVariable v : TokenizeOperator.this.tokenizeVars) {
                    target.addVariable(v);
                }
            }
        };
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.TOKENIZE;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        PropagatingTypeEnvironment env = this.createPropagatingAllInputsTypeEnvironment(ctx);
        for (int i = 0; i < this.tokenizeVars.size(); ++i) {
            env.setVarType(this.tokenizeVars.get(i), this.tokenizeVarTypes.get(i));
        }
        return env;
    }

    public List<Mutable<ILogicalExpression>> getPrimaryKeyExpressions() {
        return this.primaryKeyExprs;
    }

    public IDataSourceIndex<?, ?> getDataSourceIndex() {
        return this.dataSourceIndex;
    }

    public List<Mutable<ILogicalExpression>> getSecondaryKeyExpressions() {
        return this.secondaryKeyExprs;
    }

    public List<LogicalVariable> getTokenizeVars() {
        return this.tokenizeVars;
    }

    public Mutable<ILogicalExpression> getFilterExpression() {
        return this.filterExpr;
    }

    public InsertDeleteUpsertOperator.Kind getOperation() {
        return this.operation;
    }

    public boolean isBulkload() {
        return this.bulkload;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public List<Object> getTokenizeVarTypes() {
        return this.tokenizeVarTypes;
    }

    public void setAdditionalFilteringExpressions(List<Mutable<ILogicalExpression>> additionalFilteringExpressions) {
        this.additionalFilteringExpressions = additionalFilteringExpressions;
    }

    public List<Mutable<ILogicalExpression>> getAdditionalFilteringExpressions() {
        return this.additionalFilteringExpressions;
    }
}

