/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.typing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.typing.AbstractTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;

public class PropagateOperatorInputsTypeEnvironment
extends AbstractTypeEnvironment {
    private final List<LogicalVariable> nonNullVariables = new ArrayList<LogicalVariable>();
    private final List<List<LogicalVariable>> correlatedNullableVariableLists = new ArrayList<List<LogicalVariable>>();
    private final ILogicalOperator op;
    private final ITypingContext ctx;

    public PropagateOperatorInputsTypeEnvironment(ILogicalOperator op, ITypingContext ctx, IExpressionTypeComputer expressionTypeComputer, IMetadataProvider<?, ?> metadataProvider) {
        super(expressionTypeComputer, metadataProvider);
        this.op = op;
        this.ctx = ctx;
    }

    public List<LogicalVariable> getNonNullVariables() {
        return this.nonNullVariables;
    }

    @Override
    public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
        nonNullVariableList.addAll(this.nonNullVariables);
        return this.getVarTypeFullList(var, nonNullVariableList, correlatedNullableVariableLists);
    }

    private Object getVarTypeFullList(LogicalVariable var, List<LogicalVariable> nonNullVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists) throws AlgebricksException {
        Object t = this.varTypeMap.get(var);
        if (t != null) {
            return t;
        }
        for (Mutable<ILogicalOperator> r : this.op.getInputs()) {
            ILogicalOperator c = (ILogicalOperator)r.getValue();
            IVariableTypeEnvironment env = this.ctx.getOutputTypeEnvironment(c);
            Object t2 = env.getVarType(var, nonNullVariableList, correlatedNullableVariableLists);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    @Override
    public Object getVarType(LogicalVariable var) throws AlgebricksException {
        return this.getVarTypeFullList(var, this.nonNullVariables, this.correlatedNullableVariableLists);
    }
}

