/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushGroupByThroughProduct
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        Mutable opRef2 = (Mutable)op1.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        InnerJoinOperator join = (InnerJoinOperator)op2;
        if (!OperatorPropertiesUtil.isAlwaysTrueCond((ILogicalExpression)((ILogicalExpression)join.getCondition().getValue()))) {
            return false;
        }
        GroupByOperator gby = (GroupByOperator)op1;
        ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorToPush = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
        ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorNotToPush = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
        Mutable opLeftRef = (Mutable)join.getInputs().get(0);
        ILogicalOperator opLeft = (ILogicalOperator)opLeftRef.getValue();
        switch (this.canPushThrough(gby, opLeft, decorToPush, decorNotToPush)) {
            case REPEATED_DECORS: {
                return false;
            }
            case TRUE: {
                this.push(opRef, (Mutable<ILogicalOperator>)opRef2, 0, decorToPush, decorNotToPush, context);
                return true;
            }
            case FALSE: {
                decorToPush.clear();
                Mutable opRightRef = (Mutable)join.getInputs().get(1);
                ILogicalOperator opRight = (ILogicalOperator)opRightRef.getValue();
                if (this.canPushThrough(gby, opRight, decorToPush, decorNotToPush) == PushTestResult.TRUE) {
                    this.push(opRef, (Mutable<ILogicalOperator>)opRef2, 1, decorToPush, decorNotToPush, context);
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private void push(Mutable<ILogicalOperator> opRefGby, Mutable<ILogicalOperator> opRefJoin, int branch, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorToPush, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decorNotToPush, IOptimizationContext context) throws AlgebricksException {
        GroupByOperator gby = (GroupByOperator)opRefGby.getValue();
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)opRefJoin.getValue();
        gby.getDecorList().clear();
        gby.getDecorList().addAll(decorToPush);
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> p : decorNotToPush) {
            LogicalVariable v1 = (LogicalVariable)p.first;
            if (v1 == null) continue;
            VariableReferenceExpression varRef = (VariableReferenceExpression)((Mutable)p.second).getValue();
            LogicalVariable v2 = varRef.getVariableReference();
            OperatorManipulationUtil.substituteVarRec((AbstractLogicalOperator)join, (LogicalVariable)v2, (LogicalVariable)v1, (boolean)true, (ITypingContext)context);
        }
        Mutable branchRef = (Mutable)join.getInputs().get(branch);
        ILogicalOperator opBranch = (ILogicalOperator)branchRef.getValue();
        opRefJoin.setValue((Object)opBranch);
        branchRef.setValue((Object)gby);
        opRefGby.setValue((Object)join);
    }

    private PushTestResult canPushThrough(GroupByOperator gby, ILogicalOperator branch, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> toPush, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> notToPush) throws AlgebricksException {
        HashSet fromBranch = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)branch, fromBranch);
        ArrayList usedInGbyExprList = new ArrayList();
        for (Object p : gby.getGroupByList()) {
            ((ILogicalExpression)((Mutable)((Pair)p).second).getValue()).getUsedVariables(usedInGbyExprList);
        }
        if (!fromBranch.containsAll(usedInGbyExprList)) {
            return PushTestResult.FALSE;
        }
        HashSet free = new HashSet();
        for (ILogicalPlan p : gby.getNestedPlans()) {
            for (Mutable r : p.getRoots()) {
                OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc((AbstractLogicalOperator)((AbstractLogicalOperator)r.getValue()), free);
            }
        }
        if (!fromBranch.containsAll(free)) {
            return PushTestResult.FALSE;
        }
        HashSet<LogicalVariable> decorVarRhs = new HashSet<LogicalVariable>();
        decorVarRhs.clear();
        for (Pair p : gby.getDecorList()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                return PushTestResult.FALSE;
            }
            VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
            LogicalVariable v = varRef.getVariableReference();
            if (decorVarRhs.contains(v)) {
                return PushTestResult.REPEATED_DECORS;
            }
            decorVarRhs.add(v);
            if (fromBranch.contains(v)) {
                toPush.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)p);
                continue;
            }
            notToPush.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)p);
        }
        return PushTestResult.TRUE;
    }

    private static enum PushTestResult {
        FALSE,
        TRUE,
        REPEATED_DECORS;

    }
}

