/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.temporal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class TranslateIntervalExpressionRule
implements IAlgebraicRewriteRule {
    private static final Set<FunctionIdentifier> TRANSLATABLE_INTERVALS = new HashSet<FunctionIdentifier>();

    public TranslateIntervalExpressionRule() {
        TRANSLATABLE_INTERVALS.add(BuiltinFunctions.INTERVAL_MEETS);
        TRANSLATABLE_INTERVALS.add(BuiltinFunctions.INTERVAL_MET_BY);
        TRANSLATABLE_INTERVALS.add(BuiltinFunctions.INTERVAL_STARTS);
        TRANSLATABLE_INTERVALS.add(BuiltinFunctions.INTERVAL_STARTED_BY);
        TRANSLATABLE_INTERVALS.add(BuiltinFunctions.INTERVAL_ENDS);
        TRANSLATABLE_INTERVALS.add(BuiltinFunctions.INTERVAL_ENDED_BY);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator selectOp = (SelectOperator)op;
        Mutable exprRef = selectOp.getCondition();
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (funcExpr.getArguments().size() != 2) {
            return false;
        }
        if (!this.hasTranslatableInterval(funcExpr)) {
            return false;
        }
        return this.translateIntervalExpression((Mutable<ILogicalExpression>)exprRef, funcExpr);
    }

    private boolean hasTranslatableInterval(AbstractFunctionCallExpression funcExpr) {
        return TRANSLATABLE_INTERVALS.contains(funcExpr.getFunctionIdentifier());
    }

    private boolean translateIntervalExpression(Mutable<ILogicalExpression> exprRef, AbstractFunctionCallExpression funcExpr) {
        ILogicalExpression interval1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        ILogicalExpression interval2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
        if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_MEETS)) {
            exprRef.setValue((Object)this.getEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalStartExpr(interval2)));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_MET_BY)) {
            exprRef.setValue((Object)this.getEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalEndExpr(interval2)));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_STARTS)) {
            ILogicalExpression startExpr = this.getEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalStartExpr(interval2));
            ILogicalExpression endExpr = this.getLessThanOrEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalEndExpr(interval2));
            exprRef.setValue((Object)this.getAndExpr(startExpr, endExpr));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_STARTED_BY)) {
            ILogicalExpression startExpr = this.getEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalStartExpr(interval2));
            ILogicalExpression endExpr = this.getLessThanOrEqualExpr(this.getIntervalEndExpr(interval2), this.getIntervalEndExpr(interval1));
            exprRef.setValue((Object)this.getAndExpr(startExpr, endExpr));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_ENDS)) {
            ILogicalExpression endExpr = this.getEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalEndExpr(interval2));
            ILogicalExpression startExpr = this.getLessThanOrEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalStartExpr(interval2));
            exprRef.setValue((Object)this.getAndExpr(startExpr, endExpr));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_ENDED_BY)) {
            ILogicalExpression endExpr = this.getEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalEndExpr(interval2));
            ILogicalExpression startExpr = this.getLessThanOrEqualExpr(this.getIntervalStartExpr(interval2), this.getIntervalStartExpr(interval1));
            exprRef.setValue((Object)this.getAndExpr(startExpr, endExpr));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_BEFORE)) {
            exprRef.setValue((Object)this.getLessThanExpr(this.getIntervalEndExpr(interval1), this.getIntervalStartExpr(interval2)));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_AFTER)) {
            exprRef.setValue((Object)this.getGreaterThanExpr(this.getIntervalStartExpr(interval1), this.getIntervalEndExpr(interval2)));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_OVERLAPS)) {
            ILogicalExpression expr1 = this.getLessThanExpr(this.getIntervalStartExpr(interval1), this.getIntervalStartExpr(interval2));
            ILogicalExpression expr2 = this.getGreaterThanExpr(this.getIntervalEndExpr(interval2), this.getIntervalEndExpr(interval1));
            ILogicalExpression expr3 = this.getGreaterThanExpr(this.getIntervalEndExpr(interval1), this.getIntervalStartExpr(interval2));
            exprRef.setValue((Object)this.getAndExpr(this.getAndExpr(expr1, expr2), expr3));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_OVERLAPPED_BY)) {
            ILogicalExpression expr1 = this.getLessThanExpr(this.getIntervalStartExpr(interval2), this.getIntervalStartExpr(interval1));
            ILogicalExpression expr2 = this.getGreaterThanExpr(this.getIntervalEndExpr(interval1), this.getIntervalEndExpr(interval2));
            ILogicalExpression expr3 = this.getGreaterThanExpr(this.getIntervalEndExpr(interval2), this.getIntervalStartExpr(interval1));
            exprRef.setValue((Object)this.getAndExpr(this.getAndExpr(expr1, expr2), expr3));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_OVERLAPPING)) {
            ILogicalExpression startExpr = this.getLessThanOrEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalEndExpr(interval2));
            ILogicalExpression endExpr = this.getGreaterThanOrEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalStartExpr(interval2));
            ILogicalExpression startPointExpr = this.getNotEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalStartExpr(interval2));
            ILogicalExpression endPointExpr = this.getNotEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalEndExpr(interval2));
            exprRef.setValue((Object)this.getAndExpr(this.getAndExpr(startExpr, endExpr), this.getAndExpr(startPointExpr, endPointExpr)));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_COVERS)) {
            ILogicalExpression startExpr = this.getLessThanOrEqualExpr(this.getIntervalStartExpr(interval1), this.getIntervalStartExpr(interval2));
            ILogicalExpression endExpr = this.getGreaterThanOrEqualExpr(this.getIntervalEndExpr(interval1), this.getIntervalEndExpr(interval2));
            exprRef.setValue((Object)this.getAndExpr(startExpr, endExpr));
        } else if (funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.INTERVAL_COVERED_BY)) {
            ILogicalExpression startExpr = this.getLessThanOrEqualExpr(this.getIntervalStartExpr(interval2), this.getIntervalStartExpr(interval1));
            ILogicalExpression endExpr = this.getGreaterThanOrEqualExpr(this.getIntervalEndExpr(interval2), this.getIntervalEndExpr(interval1));
            exprRef.setValue((Object)this.getAndExpr(startExpr, endExpr));
        } else {
            return false;
        }
        return true;
    }

    private ILogicalExpression getAndExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.AND, arg1, arg2);
    }

    private ILogicalExpression getEqualExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.EQ, arg1, arg2);
    }

    private ILogicalExpression getNotEqualExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.NEQ, arg1, arg2);
    }

    private ILogicalExpression getLessThanExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.LT, arg1, arg2);
    }

    private ILogicalExpression getLessThanOrEqualExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.LE, arg1, arg2);
    }

    private ILogicalExpression getGreaterThanExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.GT, arg1, arg2);
    }

    private ILogicalExpression getGreaterThanOrEqualExpr(ILogicalExpression arg1, ILogicalExpression arg2) {
        return this.getScalarExpr(AlgebricksBuiltinFunctions.GE, arg1, arg2);
    }

    private ILogicalExpression getIntervalStartExpr(ILogicalExpression interval) {
        return this.getScalarExpr(BuiltinFunctions.ACCESSOR_TEMPORAL_INTERVAL_START, interval);
    }

    private ILogicalExpression getIntervalEndExpr(ILogicalExpression interval) {
        return this.getScalarExpr(BuiltinFunctions.ACCESSOR_TEMPORAL_INTERVAL_END, interval);
    }

    private ILogicalExpression getScalarExpr(FunctionIdentifier func, ILogicalExpression interval) {
        ArrayList<MutableObject> intervalArg = new ArrayList<MutableObject>();
        intervalArg.add(new MutableObject((Object)interval));
        ScalarFunctionCallExpression fnExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)func), intervalArg);
        fnExpr.setSourceLocation(interval.getSourceLocation());
        return fnExpr;
    }

    private ILogicalExpression getScalarExpr(FunctionIdentifier func, ILogicalExpression interval1, ILogicalExpression interval2) {
        ArrayList<MutableObject> intervalArg = new ArrayList<MutableObject>();
        intervalArg.add(new MutableObject((Object)interval1));
        intervalArg.add(new MutableObject((Object)interval2));
        ScalarFunctionCallExpression fnExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)func), intervalArg);
        fnExpr.setSourceLocation(interval1.getSourceLocation());
        return fnExpr;
    }
}

