/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.api.ICommonRequestParameters;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.translator.BaseClientRequest;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;

public class ClientRequest
extends BaseClientRequest {
    protected final long creationTime = System.nanoTime();
    protected final Thread executor;
    protected final String statement;
    protected final String clientContextId;
    protected volatile JobId jobId;

    public ClientRequest(ICommonRequestParameters requestParameters) {
        super(requestParameters.getRequestReference());
        this.clientContextId = requestParameters.getClientContextId();
        this.statement = requestParameters.getStatement();
        this.executor = Thread.currentThread();
    }

    public String getClientContextId() {
        return this.clientContextId;
    }

    public synchronized void setJobId(JobId jobId) {
        this.jobId = jobId;
        this.setRunning();
    }

    public Thread getExecutor() {
        return this.executor;
    }

    @Override
    protected void doCancel(ICcApplicationContext appCtx) throws HyracksDataException {
        if (this.jobId != null) {
            IHyracksClientConnection hcc = appCtx.getHcc();
            try {
                hcc.cancelJob(this.jobId);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        } else if (this.executor != null) {
            this.executor.interrupt();
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    protected ObjectNode asJson() {
        ObjectNode json = super.asJson();
        json.put("jobId", this.jobId != null ? this.jobId.toString() : null);
        json.put("statement", this.statement);
        json.put("clientContextID", this.clientContextId);
        return json;
    }
}

