/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ResourceAllocationRequest;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ReservationAllocationState {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ReservationAllocationState newInstance(long acceptanceTime, String user, List<ResourceAllocationRequest> resourceAllocations, ReservationId reservationId, ReservationDefinition reservationDefinition) {
        ReservationAllocationState ri = Records.newRecord(ReservationAllocationState.class);
        ri.setAcceptanceTime(acceptanceTime);
        ri.setUser(user);
        ri.setResourceAllocationRequests(resourceAllocations);
        ri.setReservationId(reservationId);
        ri.setReservationDefinition(reservationDefinition);
        return ri;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getAcceptanceTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAcceptanceTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getUser();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUser(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<ResourceAllocationRequest> getResourceAllocationRequests();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setResourceAllocationRequests(List<ResourceAllocationRequest> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationId getReservationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setReservationId(ReservationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ReservationDefinition getReservationDefinition();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setReservationDefinition(ReservationDefinition var1);
}

