/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.profiling;

import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class ConnectorReceiverProfilingFrameReader
implements IFrameReader {
    private final IFrameReader reader;
    private final ICounter openCounter;
    private final ICounter closeCounter;
    private final ICounter frameCounter;

    public ConnectorReceiverProfilingFrameReader(IHyracksTaskContext ctx, IFrameReader reader, ConnectorDescriptorId cdId, int receiverIndex) {
        this.reader = reader;
        this.openCounter = ctx.getCounterContext().getCounter(cdId + ".receiver." + receiverIndex + ".open", true);
        this.closeCounter = ctx.getCounterContext().getCounter(cdId + ".receiver." + receiverIndex + ".close", true);
        this.frameCounter = ctx.getCounterContext().getCounter(cdId + ".receiver." + receiverIndex + ".nextFrame", true);
    }

    public void open() throws HyracksDataException {
        this.reader.open();
        this.openCounter.update(1L);
    }

    public boolean nextFrame(IFrame frame) throws HyracksDataException {
        boolean status = this.reader.nextFrame(frame);
        if (status) {
            this.frameCounter.update(1L);
        }
        return status;
    }

    public void close() throws HyracksDataException {
        this.reader.close();
        this.closeCounter.update(1L);
    }
}

