/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class UnionStructObjectInspector
extends StructObjectInspector {
    private List<StructObjectInspector> unionObjectInspectors;
    private List<MyField> fields;

    protected UnionStructObjectInspector() {
    }

    protected UnionStructObjectInspector(List<StructObjectInspector> unionObjectInspectors) {
        this.init(unionObjectInspectors);
    }

    void init(List<StructObjectInspector> unionObjectInspectors) {
        int i;
        this.unionObjectInspectors = unionObjectInspectors;
        int totalSize = 0;
        for (i = 0; i < unionObjectInspectors.size(); ++i) {
            totalSize += unionObjectInspectors.get(i).getAllStructFieldRefs().size();
        }
        this.fields = new ArrayList<MyField>(totalSize);
        for (i = 0; i < unionObjectInspectors.size(); ++i) {
            StructObjectInspector oi = unionObjectInspectors.get(i);
            for (StructField structField : oi.getAllStructFieldRefs()) {
                this.fields.add(new MyField(i, structField));
            }
        }
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName(this);
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        Object fieldData;
        if (data == null) {
            return null;
        }
        MyField f = (MyField)fieldRef;
        if (!(data instanceof List)) {
            Object[] list = (Object[])data;
            assert (list.length == this.unionObjectInspectors.size());
            fieldData = list[f.structID];
        } else {
            List list = (List)data;
            assert (list.size() == this.unionObjectInspectors.size());
            fieldData = list.get(f.structID);
        }
        return this.unionObjectInspectors.get(f.structID).getStructFieldData(fieldData, f.structField);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof List)) {
            data = Arrays.asList((Object[])data);
        }
        List list = data;
        assert (list.size() == this.unionObjectInspectors.size());
        ArrayList<Object> result = new ArrayList<Object>(this.fields.size());
        for (int i = 0; i < this.unionObjectInspectors.size(); ++i) {
            result.addAll(this.unionObjectInspectors.get(i).getStructFieldsDataAsList(list.get(i)));
        }
        return result;
    }

    public static class MyField
    implements StructField {
        protected int structID;
        protected StructField structField;

        protected MyField() {
        }

        public MyField(int structID, StructField structField) {
            this.structID = structID;
            this.structField = structField;
        }

        @Override
        public String getFieldName() {
            return this.structField.getFieldName();
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.structField.getFieldObjectInspector();
        }

        @Override
        public String getFieldComment() {
            return this.structField.getFieldComment();
        }
    }
}

