/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.input.record.reader.aws.AwsS3InputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.CleanupUtils;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3InputStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    private Map<String, String> configuration;
    private final List<PartitionWorkLoadBasedOnSize> partitionWorkLoadsBasedOnSize = new ArrayList<PartitionWorkLoadBasedOnSize>();
    private transient AlgebricksAbsolutePartitionConstraint partitionConstraint;

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.STREAM;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new AwsS3InputStream(this.configuration, this.partitionWorkLoadsBasedOnSize.get(partition).getFilePaths());
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        return this.partitionConstraint;
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        BiPredicate<List<Matcher>, String> p;
        ArrayList<Matcher> matchersList;
        this.configuration = configuration;
        ICcApplicationContext ccApplicationContext = (ICcApplicationContext)ctx.getApplicationContext();
        String container = configuration.get("container");
        ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
        ExternalDataUtils.AwsS3.validateIncludeExclude(configuration);
        ArrayList<Matcher> includeMatchers = new ArrayList<Matcher>();
        ArrayList<Matcher> excludeMatchers = new ArrayList<Matcher>();
        String pattern = null;
        try {
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                if (entry.getKey().startsWith("include")) {
                    pattern = entry.getValue();
                    includeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
                    continue;
                }
                if (!entry.getKey().startsWith("exclude")) continue;
                pattern = entry.getValue();
                excludeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
            }
        }
        catch (PatternSyntaxException ex) {
            throw new CompilationException(1113, new Serializable[]{pattern});
        }
        if (!includeMatchers.isEmpty()) {
            matchersList = includeMatchers;
            p = (matchers, key) -> ExternalDataUtils.matchPatterns(matchers, key);
        } else if (!excludeMatchers.isEmpty()) {
            matchersList = excludeMatchers;
            p = (matchers, key) -> !ExternalDataUtils.matchPatterns(matchers, key);
        } else {
            matchersList = Collections.emptyList();
            p = (matchers, key) -> true;
        }
        S3Client s3Client = ExternalDataUtils.AwsS3.buildAwsS3Client(configuration);
        ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(container);
        ExternalDataUtils.AwsS3.setPrefix(configuration, listObjectsBuilder);
        boolean done = false;
        String newMarker = null;
        try {
            while (!done) {
                ListObjectsV2Response listObjectsResponse = newMarker == null ? s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.build()) : s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.continuationToken(newMarker).build());
                this.collectAndFilterFiles(listObjectsResponse.contents(), p, matchersList, filesOnly);
                if (!listObjectsResponse.isTruncated().booleanValue()) {
                    done = true;
                    continue;
                }
                newMarker = listObjectsResponse.nextContinuationToken();
            }
        }
        catch (SdkException ex) {
            throw new CompilationException(1108, new Serializable[]{ex.getMessage()});
        }
        finally {
            if (s3Client != null) {
                CleanupUtils.close((AutoCloseable)s3Client, null);
            }
        }
        if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
            Warning warning = WarningUtil.forAsterix(null, (int)1114, (Serializable[])new Serializable[0]);
            warningCollector.warn(warning);
        }
        this.partitionConstraint = ccApplicationContext.getClusterStateManager().getClusterLocations();
        int partitionsCount = this.partitionConstraint.getLocations().length;
        this.distributeWorkLoad(filesOnly, partitionsCount);
    }

    private void collectAndFilterFiles(List<S3Object> s3Objects, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<S3Object> filesOnly) {
        for (S3Object object : s3Objects) {
            if (object.key().endsWith("/") || !predicate.test(matchers, object.key())) continue;
            filesOnly.add(object);
        }
    }

    private void distributeWorkLoad(List<S3Object> fileObjects, int partitionsCount) {
        for (int i = 0; i < partitionsCount; ++i) {
            this.partitionWorkLoadsBasedOnSize.add(new PartitionWorkLoadBasedOnSize());
        }
        for (S3Object object : fileObjects) {
            PartitionWorkLoadBasedOnSize smallest = this.getSmallestWorkLoad();
            smallest.addFilePath(object.key(), object.size());
        }
    }

    private PartitionWorkLoadBasedOnSize getSmallestWorkLoad() {
        PartitionWorkLoadBasedOnSize smallest = this.partitionWorkLoadsBasedOnSize.get(0);
        for (PartitionWorkLoadBasedOnSize partition : this.partitionWorkLoadsBasedOnSize) {
            if (partition.getTotalSize() == 0L) {
                smallest = partition;
                break;
            }
            if (partition.getTotalSize() >= smallest.getTotalSize()) continue;
            smallest = partition;
        }
        return smallest;
    }

    private static class PartitionWorkLoadBasedOnSize
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> filePaths = new ArrayList<String>();
        private long totalSize = 0L;

        PartitionWorkLoadBasedOnSize() {
        }

        public List<String> getFilePaths() {
            return this.filePaths;
        }

        public void addFilePath(String filePath, long size) {
            this.filePaths.add(filePath);
            this.totalSize += size;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "Files: " + this.filePaths.size() + ", Total Size: " + this.totalSize;
        }
    }
}

