/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.asterix.external.input.stream.factory.LocalFSInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketClientInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketServerInputStreamFactory;
import org.apache.asterix.external.provider.StreamRecordReaderProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class StreamRecordReaderFactory
implements IRecordReaderFactory<char[]> {
    private static final long serialVersionUID = 1L;
    protected IInputStreamFactory streamFactory;
    protected Map<String, String> configuration;
    protected Class recordReaderClazz;
    private static final List<String> recordReaderNames = Collections.unmodifiableList(Arrays.asList("localfs", "socket_adapter", "socket", "socket-client"));

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public Class<?> getRecordClass() {
        return char[].class;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        return this.streamFactory.getPartitionConstraint();
    }

    private void configureInputStreamFactory(Map<String, String> config) throws CompilationException {
        String reader = config.get("reader");
        if (reader.equals("localfs")) {
            this.streamFactory = new LocalFSInputStreamFactory();
        } else if (reader.equals("socket_adapter") || reader.equals("socket")) {
            this.streamFactory = new SocketServerInputStreamFactory();
        } else if (reader.equals("socket-client")) {
            this.streamFactory = new SocketClientInputStreamFactory();
        } else {
            throw new CompilationException(3085, new Serializable[0]);
        }
    }

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector) throws HyracksDataException, AlgebricksException {
        this.configuration = configuration;
        this.configureInputStreamFactory(configuration);
        this.streamFactory.configure(serviceCtx, configuration, warningCollector);
        this.recordReaderClazz = StreamRecordReaderProvider.getRecordReaderClazz(configuration);
    }

    @Override
    public IRecordReader<? extends char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            StreamRecordReader streamRecordReader = (StreamRecordReader)this.recordReaderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            streamRecordReader.configure(ctx, this.streamFactory.createInputStream(ctx, partition), this.configuration);
            return streamRecordReader;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }
}

