/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.ADMDataParser;
import org.apache.asterix.external.parser.factory.AbstractRecordStreamParserFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ADMDataParserFactory
extends AbstractRecordStreamParserFactory<char[]> {
    private static final long serialVersionUID = 1L;
    private static final List<String> parserFormats = Collections.unmodifiableList(Arrays.asList("adm", "semi-structured"));

    @Override
    public IRecordDataParser<char[]> createRecordParser(IHyracksTaskContext ctx) {
        return this.createParser();
    }

    private ADMDataParser createParser() {
        return new ADMDataParser(this.recordType, ExternalDataUtils.getDataSourceType(this.configuration).equals((Object)IExternalDataSourceFactory.DataSourceType.STREAM));
    }

    @Override
    public Class<? extends char[]> getRecordClass() {
        return char[].class;
    }

    @Override
    public IStreamDataParser createInputStreamParser(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return this.createParser();
    }

    @Override
    public void setMetaType(ARecordType metaType) {
    }

    @Override
    public List<String> getParserFormats() {
        return parserFormats;
    }
}

