/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.nio.ByteBuffer;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class TxnEntityId {
    public boolean isByteArrayPKValue;
    public long txnId;
    public int datasetId;
    public int pkHashValue;
    public int pkSize;
    public byte[] byteArrayPKValue;
    public ITupleReference tupleReferencePKValue;

    public TxnEntityId(long txnId, int datasetId, int pkHashValue, ITupleReference pkValue, int pkSize, boolean isByteArrayPKValue) {
        this.txnId = txnId;
        this.datasetId = datasetId;
        this.pkHashValue = pkHashValue;
        this.pkSize = pkSize;
        this.isByteArrayPKValue = isByteArrayPKValue;
        if (isByteArrayPKValue) {
            this.byteArrayPKValue = new byte[pkSize];
            TxnEntityId.readPKValueIntoByteArray(pkValue, pkSize, this.byteArrayPKValue);
        } else {
            this.tupleReferencePKValue = pkValue;
        }
    }

    public TxnEntityId() {
    }

    private static void readPKValueIntoByteArray(ITupleReference pkValue, int pkSize, byte[] byteArrayPKValue) {
        int readOffset = pkValue.getFieldStart(0);
        byte[] readBuffer = pkValue.getFieldData(0);
        for (int i = 0; i < pkSize; ++i) {
            byteArrayPKValue[i] = readBuffer[readOffset + i];
        }
    }

    public void setTxnId(long txnId, int datasetId, int pkHashValue, ITupleReference pkValue, int pkSize) {
        this.txnId = txnId;
        this.datasetId = datasetId;
        this.pkHashValue = pkHashValue;
        this.tupleReferencePKValue = pkValue;
        this.pkSize = pkSize;
        this.isByteArrayPKValue = false;
    }

    public String toString() {
        return "[" + this.txnId + "," + this.datasetId + "," + this.pkHashValue + "," + this.pkSize + "]";
    }

    public int hashCode() {
        return this.pkHashValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxnEntityId)) {
            return false;
        }
        TxnEntityId txnEntityId = (TxnEntityId)o;
        return txnEntityId.pkHashValue == this.pkHashValue && txnEntityId.datasetId == this.datasetId && txnEntityId.txnId == this.txnId && this.pkSize == txnEntityId.pkSize && this.isEqualTo(txnEntityId);
    }

    private boolean isEqualTo(TxnEntityId txnEntityId) {
        if (this.isByteArrayPKValue && txnEntityId.isByteArrayPKValue) {
            return TxnEntityId.isEqual(this.byteArrayPKValue, txnEntityId.byteArrayPKValue, this.pkSize);
        }
        if (this.isByteArrayPKValue && !txnEntityId.isByteArrayPKValue) {
            return TxnEntityId.isEqual(this.byteArrayPKValue, txnEntityId.tupleReferencePKValue, this.pkSize);
        }
        if (!this.isByteArrayPKValue && txnEntityId.isByteArrayPKValue) {
            return TxnEntityId.isEqual(txnEntityId.byteArrayPKValue, this.tupleReferencePKValue, this.pkSize);
        }
        return TxnEntityId.isEqual(this.tupleReferencePKValue, txnEntityId.tupleReferencePKValue, this.pkSize);
    }

    private static boolean isEqual(byte[] a, byte[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(byte[] a, ITupleReference b, int size) {
        int readOffset = b.getFieldStart(0);
        byte[] readBuffer = b.getFieldData(0);
        for (int i = 0; i < size; ++i) {
            if (a[i] == readBuffer[readOffset + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(ITupleReference a, ITupleReference b, int size) {
        int aOffset = a.getFieldStart(0);
        byte[] aBuffer = a.getFieldData(0);
        int bOffset = b.getFieldStart(0);
        byte[] bBuffer = b.getFieldData(0);
        for (int i = 0; i < size; ++i) {
            if (aBuffer[aOffset + i] == bBuffer[bOffset + i]) continue;
            return false;
        }
        return true;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putLong(this.txnId);
        buffer.putInt(this.datasetId);
        buffer.putInt(this.pkHashValue);
        buffer.putInt(this.pkSize);
        buffer.put((byte)(this.isByteArrayPKValue ? 1 : 0));
        if (this.isByteArrayPKValue) {
            buffer.put(this.byteArrayPKValue);
        }
    }

    public static TxnEntityId deserialize(ByteBuffer buffer) {
        TxnEntityId txnEntityId = new TxnEntityId();
        txnEntityId.txnId = buffer.getLong();
        txnEntityId.datasetId = buffer.getInt();
        txnEntityId.pkHashValue = buffer.getInt();
        txnEntityId.pkSize = buffer.getInt();
        boolean bl = txnEntityId.isByteArrayPKValue = buffer.get() == 1;
        if (txnEntityId.isByteArrayPKValue) {
            byte[] byteArrayPKValue = new byte[txnEntityId.pkSize];
            buffer.get(byteArrayPKValue);
            txnEntityId.byteArrayPKValue = byteArrayPKValue;
        }
        return txnEntityId;
    }

    public int getCurrentSize() {
        int size = 21;
        if (this.isByteArrayPKValue && this.byteArrayPKValue != null) {
            size += this.byteArrayPKValue.length;
        }
        return size;
    }
}

