/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.state;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.state.Graph;
import org.apache.hadoop.yarn.state.StateMachineFactory;

@InterfaceAudience.Private
public class VisualizeStateMachine {
    public static Graph getGraphFromClasses(String graphName, List<String> classes) throws Exception {
        Graph ret = null;
        if (classes.size() != 1) {
            ret = new Graph(graphName);
        }
        for (String className : classes) {
            Class<?> clz = Class.forName(className);
            Field factoryField = clz.getDeclaredField("stateMachineFactory");
            factoryField.setAccessible(true);
            StateMachineFactory factory = (StateMachineFactory)factoryField.get(null);
            if (classes.size() == 1) {
                return factory.generateStateGraph(graphName);
            }
            String gname = clz.getSimpleName();
            if (gname.endsWith("Impl")) {
                gname = gname.substring(0, gname.length() - 4);
            }
            ret.addSubGraph(factory.generateStateGraph(gname));
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.printf("Usage: %s <GraphName> <class[,class[,...]]> <OutputFile>%n", VisualizeStateMachine.class.getName());
            System.exit(1);
        }
        String[] classes = args[1].split(",");
        ArrayList<String> validClasses = new ArrayList<String>();
        for (String c : classes) {
            String vc = c.trim();
            if (vc.length() <= 0) continue;
            validClasses.add(vc);
        }
        Graph g = VisualizeStateMachine.getGraphFromClasses(args[0], validClasses);
        g.save(args[2]);
    }
}

