/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeControllerDetailsHelper {
    private NodeControllerDetailsHelper() {
    }

    public static ObjectNode fixupKeys(ObjectNode json) {
        ArrayList keys = new ArrayList();
        Iterator iter = json.fieldNames();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        for (String key : keys) {
            String newKey = key.replace('-', '_');
            if (newKey.equals(key)) continue;
            json.set(newKey, json.remove(key));
        }
        return json;
    }

    public static ObjectNode processNodeDetailsJSON(ObjectNode json, ObjectMapper om) {
        int index = json.get("rrd-ptr").asInt() - 1;
        json.remove("rrd-ptr");
        ArrayList keys = new ArrayList();
        Iterator iter = json.fieldNames();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        ArrayNode gcNames = (ArrayNode)json.get("gc-names");
        ArrayNode gcCollectionTimes = (ArrayNode)json.get("gc-collection-times");
        ArrayNode gcCollectionCounts = (ArrayNode)json.get("gc-collection-counts");
        for (String key : keys) {
            if (key.startsWith("gc-")) {
                json.remove(key);
                continue;
            }
            JsonNode keyNode = json.get(key);
            if (!(keyNode instanceof ArrayNode)) continue;
            ArrayNode valueArray = (ArrayNode)keyNode;
            if (index == -1) {
                index = valueArray.size() - 1;
            }
            JsonNode value = valueArray.get(index);
            json.remove(key);
            json.set(key.replaceAll("s$", ""), value);
        }
        ArrayNode gcs = om.createArrayNode();
        for (int i = 0; i < gcNames.size(); ++i) {
            ObjectNode gc = om.createObjectNode();
            gc.set("name", gcNames.get(i));
            gc.set("collection-time", gcCollectionTimes.get(i).get(index));
            gc.set("collection-count", gcCollectionCounts.get(i).get(index));
            NodeControllerDetailsHelper.fixupKeys(gc);
            gcs.add((JsonNode)gc);
        }
        json.set("gcs", (JsonNode)gcs);
        return json;
    }
}

