/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import org.apache.hyracks.util.IntSerDeUtils;

public class FrameTupleAppenderAccessor
extends FrameTupleAppender
implements IFrameTupleAccessor {
    private int tupleCountOffset;
    private final RecordDescriptor recordDescriptor;

    public FrameTupleAppenderAccessor(RecordDescriptor recordDescriptor) {
        this.recordDescriptor = recordDescriptor;
    }

    public void reset(ByteBuffer buffer) {
        throw new IllegalAccessError("should not call this function");
    }

    public int getTupleStartOffset(int tupleIndex) {
        int offset = tupleIndex == 0 ? 5 : IntSerDeUtils.getInt((byte[])this.getBuffer().array(), (int)(this.tupleCountOffset - 4 * tupleIndex));
        return offset;
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleEndOffset(int tupleIndex) {
        return IntSerDeUtils.getInt((byte[])this.getBuffer().array(), (int)(this.tupleCountOffset - 4 * (tupleIndex + 1)));
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])this.getBuffer().array(), (int)(this.getTupleStartOffset(tupleIndex) + (fIdx - 1) * 4));
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return IntSerDeUtils.getInt((byte[])this.getBuffer().array(), (int)(this.getTupleStartOffset(tupleIndex) + fIdx * 4));
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.getFieldEndOffset(tupleIndex, fIdx) - this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleLength(int tupleIndex) {
        return this.getTupleEndOffset(tupleIndex) - this.getTupleStartOffset(tupleIndex);
    }

    public int getFieldSlotsLength() {
        return this.getFieldCount() * 4;
    }

    public void prettyPrint() {
        ByteBufferInputStream bbis = new ByteBufferInputStream();
        DataInputStream dis = new DataInputStream(bbis);
        int tc = this.getTupleCount();
        System.err.println("TC: " + tc);
        for (int i = 0; i < tc; ++i) {
            this.prettyPrint(i, bbis, dis);
        }
    }

    protected void prettyPrint(int tid, ByteBufferInputStream bbis, DataInputStream dis) {
        System.err.print("tid" + tid + ":(" + this.getTupleStartOffset(tid) + ", " + this.getTupleEndOffset(tid) + ")[");
        for (int j = 0; j < this.getFieldCount(); ++j) {
            System.err.print("f" + j + ":(" + this.getFieldStartOffset(tid, j) + ", " + this.getFieldEndOffset(tid, j) + ") ");
            System.err.print("{");
            bbis.setByteBuffer(this.getBuffer(), this.getTupleStartOffset(tid) + this.getFieldSlotsLength() + this.getFieldStartOffset(tid, j));
            try {
                System.err.print(this.recordDescriptor.getFields()[j].deserialize((DataInput)dis));
            }
            catch (HyracksDataException e) {
                e.printStackTrace();
            }
            System.err.print("}");
        }
        System.err.println();
    }

    public void prettyPrint(int tid) {
        ByteBufferInputStream bbis = new ByteBufferInputStream();
        DataInputStream dis = new DataInputStream(bbis);
        this.prettyPrint(tid, bbis, dis);
    }

    public int getFieldCount() {
        return this.recordDescriptor.getFieldCount();
    }

    @Override
    public void reset(IFrame frame, boolean clear) throws HyracksDataException {
        super.reset(frame, clear);
        this.tupleCountOffset = FrameHelper.getTupleCountOffset((int)frame.getFrameSize());
    }
}

