/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.normalizers;

import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyProperties;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.dataflow.common.utils.NormalizedKeyUtils;

public class DoubleNormalizedKeyComputerFactory
implements INormalizedKeyComputerFactory {
    private static final long serialVersionUID = 1L;
    public static final INormalizedKeyProperties PROPERTIES = new INormalizedKeyProperties(){
        private static final long serialVersionUID = 1L;

        public int getNormalizedKeyLength() {
            return 2;
        }

        public boolean isDecisive() {
            return true;
        }
    };

    public INormalizedKeyComputer createNormalizedKeyComputer() {
        return new INormalizedKeyComputer(){

            public void normalize(byte[] bytes, int start, int length, int[] normalizedKeys, int keyStart) {
                long value = LongPointable.getLong((byte[])bytes, (int)start);
                value = value >= 0L ? (value ^= Long.MIN_VALUE) : (value ^= 0xFFFFFFFFFFFFFFFFL);
                NormalizedKeyUtils.putLongIntoNormalizedKeys(normalizedKeys, keyStart, value);
            }

            public INormalizedKeyProperties getNormalizedKeyProperties() {
                return PROPERTIES;
            }
        };
    }

    public INormalizedKeyProperties getNormalizedKeyProperties() {
        return PROPERTIES;
    }
}

